from abc import ABCMeta, abstractmethod
import logging

from utils.annotations import PublicAPI
from utils.typing import SampleBatchType

logger = logging.getLogger(__name__)


@PublicAPI
class InputReader(metaclass=ABCMeta):
    """API for collecting and returning experiences during policy evaluation."""

    @abstractmethod
    @PublicAPI
    def next(self) -> SampleBatchType:
        """Returns the next batch of read experiences.

        Returns:
            The experience read (SampleBatch or MultiAgentBatch).
        """
        raise NotImplementedError
