export NCCL_DEBUG=WARNING

date=$(date +"%m%d")

echo "date: ${date}"

model="$1"
dataset="$2"
run_name="$3"

echo "model: ${model}"
echo "dataset: ${dataset}"
echo "run_name: ${run_name}"


epoch=5
max_len=4096
lora_rank=8


echo "———————————————————— Test ————————————————————"

if [ "${model}" = "llama3" ]; then
  model_name_or_path="/datanfs4/name/HuggingFaceModels/meta-llama/Meta-Llama-3-8B"
elif [ "${model}" = "llama3.1" ]; then
  model_name_or_path="/datanfs4/name/HuggingFaceModels/meta-llama/Llama-3.1-8B"
elif [ "${model}" = "qwen" ]; then
  model_name_or_path="/datanfs4/name/HuggingFaceModels/Qwen/Qwen3-8B-Base"
fi

if [ "${dataset}" = "gsm8k" ]; then
  template="vanilla_qa"
else
  template="vanilla"
fi



python src/vllm_infer.py \
        --model_name_or_path ${model_name_or_path} \
        --adapter_name_or_path "ckpt/cl/sft/${model}/${run_name}/${task_order}" \
        --cutoff_len 4096 \
        --max_new_tokens 1024 \
        --template "vanilla" \
        --dataset_dir "data/cl" \
        --dataset "${dataset}_test" \
        --save_name "ckpt/cl/sft/${model}/${run_name}/eval_results/${task_order}/${eval_task_order}/generated_predictions.jsonl"
