from typing import Any, Dict, Optional
from datetime import datetime
import re

from huggingface_hub import login as hf_login

from llamafactory.hparams import get_train_args
from llamafactory.train.sft import save_hidden_states
from llamafactory.train.callbacks import LogCallback

# hf_login(token='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')

date = datetime.now().strftime('%m%d')


def main(args: Optional[Dict[str, Any]] = None):
    callbacks = [LogCallback()]
    model_args, data_args, training_args, finetuning_args, generating_args = get_train_args(args)

    save_hidden_states(model_args, data_args, training_args, finetuning_args, generating_args)

if __name__ == '__main__':
    main()
