import nltk

def download_if_not_exists(resource):
    try:
        nltk.data.find(resource)
        print(f"{resource} is already downloaded.")
    except LookupError:
        print(f"{resource} not found. Downloading...")
        nltk.download(resource.split('/')[-1])

def download_punkt():
    download_if_not_exists('tokenizers/punkt')
    download_if_not_exists('tokenizers/punkt_tab')