# Neother Embeddings
This code is developed based on  [Tensor Decompositions for Temporal Knowledge Base Completion](https://github.com/facebookresearch/tkbc.git) (ICLR 2020).

## Training and Test
To train and test on the task TAM:
```
python ne/main.py --model NE \
    --dataset GDELT \
    --valid_freq 10000 --max_epochs 200 \
    --rank 400 --omg_max 4000 \
    --objective_mode classification \
    --learning_rate 1e-1 --batch_size 10000 \
    --pos_score 1 \
    --g_th 0.05 \
    --omg_init exp \
    --rule specific \
    --run_mode train \
    --task tam \
    --tag tam
```

To train and test on the task TAQ:
```
python ne/main.py --model NE \
    --dataset ICEWS18_forecasting \
    --valid_freq 500 --max_epochs 10 \
    --rank 400 --omg_max 400 \
    --objective_mode classification \
    --learning_rate 1e-1 --batch_size 10000 \
    --g_th 0.7 \
    --omg_init exp \
    --pos_score 1 \
    --run_mode train \
    --rule specific \
    --query_count 1000 --query_pair_freq 5 \
    --task taq \
    --tag taq
```

'omg_max', 'pos_score' and 'g_th' represent $\omega_{max}$, $\alpha_{p}$ and $p_{th}$ defined in the paper respectively.

Every run will create a log directory in `./logs` and also runtime logs will be outputed to `./run_time.log`.
