# TreeGen

## Setup

To set up the project environment, follow these steps:

1.	Create a virtual environment (using venv is recommended as Conda environments may not work properly):
```bash
python3 -m venv venv
source venv/bin/activate 
```

2.	Install the required packages:

```bash
pip install -r requirements.txt
pip install -e .
```


## Usage

To run experiments, execute the following command from the root directory:

```bash
python src/train.py -m experiment=7_qcd_small_small_model.yaml
```

## Logging

To enable logging with Weights & Biases, set the logger in your configuration:

# In your experiment YAML file
logger:
  wandb:
    name: "experiment name"
    group: "group"
    tags: ["TreeGen"]
