from jaxtyping import Float
from torch import Tensor, nn
from torch_geometric.data import Batch

from src.utils.adjacency_utils import compute_P_anc, get_adj_indices


class ProbaAncestor(nn.Module):
    """Probabilistic Ancestor Feature."""

    def __init__(self, n: int) -> None:
        """Probabilistic Ancestor.

        :param n: Maximal number of nodes in any graph.
        """
        super().__init__()
        self.n = n

    def forward(self, data: Batch) -> Float[Tensor, "n_edges"]:
        """Compute probabilistic ancestors.

        :param data: PyG batch object.
        :return: Probabilistic ancestor probabilities.
        """
        P_anc = compute_P_anc(data, self.n)
        batch, start, end = get_adj_indices(data, self.n)
        return P_anc[batch, start, end]
