from jaxtyping import Float
from torch import Tensor, nn
from torch_geometric.data import Batch


class NClasses(nn.Module):
    """Number of classes feature."""

    def __init__(self) -> None:
        """Initialize the Number of classes feature."""
        super().__init__()

    @property
    def d(self) -> int:
        """Return the dimension of the Number of classes feature.

        :return: Dimension of Number of classes feature.
        """
        return 1

    def forward(self, data: Batch) -> Float[Tensor, "n_nodes 1"]:
        """Compute the Number of potential parents for each node.

        :param data: PyG batch object.
        :return: Number of classes feature.
        """
        return data.n_parents.view(-1, 1)
