from jaxtyping import Float
from torch import Tensor, nn
from torch_geometric.data import Batch


class Parent(nn.Module):
    """Parent feature.

    Which is a binary indicator of whether a node is a parent node.
    """

    def __init__(self) -> None:
        """Initialize the Parent feature."""
        super().__init__()

    @property
    def d(self) -> int:
        """Return the dimension of the Parent feature.

        :return: Dimension of Parent feature.
        """
        return 1

    def forward(self, data: Batch) -> Float[Tensor, "n_nodes 1"]:
        """Compute the Parent feature.

        :param data: PyG batch object.
        :return: Parent feature.
        """
        return data.parent_mask.view(-1, 1)
