from jaxtyping import Float
from torch import Tensor, nn
from torch_geometric.data import Batch

from src.utils.sparse_utils import sparse_sum


class ProbaMass(nn.Module):
    """Probability Mass Feature.

    Defined as the sum of the edge weights of the incoming edges.
    """

    def __init__(self) -> None:
        """Initialize the Probability Mass feature."""
        super().__init__()

    @property
    def d(self) -> int:
        """Return the dimension of the Probability Mass feature.

        :return: Dimension of Probability Mass feature.
        """
        return 1

    def forward(self, data: Batch) -> Float[Tensor, "n_nodes 1"]:
        """Compute the Probability Mass feature.

        :param data: PyG batch object.
        :return: Probability Mass feature.
        """
        proba_mass = sparse_sum(data.edge_index, data.edge_attr, 0)
        return proba_mass.view(-1, 1)
