from jaxtyping import Float
from torch import Tensor, nn
from torch.nn import functional as F


class OutputAdapter(nn.Module):
    """OutputAdapter for PyG models. Transforms output using sigmoid activation."""

    def __init__(
        self,
        prediction_head: nn.Module,
    ) -> None:
        """Initialize the GNNOutputAdapter.

        :param prediction_head: Prediction head that takes the output of the PyG models and predicts edge
            logits.
        """
        super().__init__()

        self.prediction_head = prediction_head

    def forward(
        self,
        x: Float[Tensor, "n_nodes d_node"],
        edge_index: Float[Tensor, "2 n_edges"],
        edge_attr: Float[Tensor, "n_edges d_edge"],
    ) -> Float[Tensor, "n_edges"]:
        """Computes edge probabilities from the output of the backbone.

        :param x: Output of the backbone.
        :param edge_index: Edge index.
        :param edge_attr: Edge features.
        :return: Predicted edge probabilities.
        """
        logits = self.prediction_head(x, edge_index, edge_attr)
        return F.sigmoid(logits)
