import torch
from jaxtyping import Float
from torch import Tensor, nn
from torch_geometric.data import Batch

from src.utils.sparse_utils import make_sparse_matrix, pad_values_of_sparse_matrix


class Adjacency(nn.Module):
    """Adjacency Matrix Features."""

    def __init__(self) -> None:
        """Initialize Adjacency Matrix Features."""
        super().__init__()

    @property
    def d(self) -> int:
        """Return dimension of Adjacency Matrix Features.

        :return: Dimension of Ginkgo Features.
        """
        return 2

    def forward(
        self, data: Batch, fully_connected_index: Float[Tensor, "2 n_fully_connected_edges"]
    ) -> Float[Tensor, "n_edges 2"]:
        """Compute the Adjacency Matrix Features.

        :param data: PyG batch object.
        :return: Adjacency Matrix Features.
        """
        adj = make_sparse_matrix(data.edge_index, data.edge_attr)
        adj_feature = pad_values_of_sparse_matrix(adj, fully_connected_index)
        adj_transposed_feature = pad_values_of_sparse_matrix(adj.T, fully_connected_index)
        return torch.stack([adj_feature, adj_transposed_feature], dim=1)
