from jaxtyping import Float
from torch import Tensor, nn
from torch_geometric.data import Batch


class Time(nn.Module):
    """Time Feature."""

    def __init__(self) -> None:
        """Initialize the Time Feature."""
        super().__init__()

    @property
    def d(self) -> int:
        """Return the dimension of the Time Feature.

        :return: Dimension of Time Feature.
        """
        return 1

    def forward(self, data: Batch) -> Float[Tensor, "n_nodes 1"]:
        """Compute the Time Feature using the t attribute of the PyG batch object.

        :param data: PyG batch object.
        :return: Time Feature.
        """
        return data.t.view(-1, 1)
