import requests

subscription_key = ""
search_url = "https://api.bing.microsoft.com/v7.0/search"
headers = {"Ocp-Apim-Subscription-Key": subscription_key}


def bing_search_response(search_term):
    params = {"q": search_term, "textDecorations": False, "textFormat": "HTML", "responseFilter": "webpages"}
    response = requests.get(search_url, headers=headers, params=params)
    response.raise_for_status()
    search_results = response.json()
    return search_results


def bing_search_results_from_response(search_results, number_of_results=3):
    no_info_websites = ["facebook"]
    results = []
    count = 0
    if 'webPages' in search_results and 'value' in search_results['webPages']:
        for page in search_results['webPages']['value']:
            if (count == number_of_results):
                break

            skip_page = False
            for no_info_website in no_info_websites:
                if (no_info_website in page['url'].lower()):
                    skip_page = True
                    break

            if (skip_page == False):
                result = {
                    'url': page['url'],
                    'title': page['name'],
                    'snippet': page['snippet']
                }
                results.append(result)
                count += 1

    result_text = ""
    for result in results:
        result_text += result["title"] + ", "
        result_text += result["snippet"]
        result_text += "\n"
    return result_text


def bing_search_result(search_term, number_of_results=3):
    no_info_websites = ["facebook"]

    params = {"q": search_term, "textDecorations": False, "textFormat": "HTML", "responseFilter": "webpages"}
    response = requests.get(search_url, headers=headers, params=params)
    response.raise_for_status()
    search_results = response.json()

    results = []
    count = 0
    if 'webPages' in search_results and 'value' in search_results['webPages']:
        for page in search_results['webPages']['value']:
            if (count == number_of_results):
                break

            skip_page = False
            for no_info_website in no_info_websites:
                if(no_info_website in page['url'].lower()):
                    skip_page = True
                    break

            if(skip_page == False):
                result = {
                    'url': page['url'],
                    'title': page['name'],
                    'snippet': page['snippet']
                }
                results.append(result)
                count += 1

    result_text = ""
    for result in results:
        result_text += result["title"] + ", "
        result_text += result["snippet"]
        result_text += "\n"
    return result_text
