% img = d by num images
% d = dimension
% num_img = number of images

function db = faces_process(faces_struct)

    labels = faces_struct.poses(1,:);
    labels = labels > 0.0;
    
    stride = zeros(1,2);
    supp = zeros(4096, 698);
    w = zeros(1, 698);
    
    pos = sum(faces_struct.poses(1,:) > 0);
    neg = 698 - pos;
    w(:, 1:pos) = 1.0/pos;
    w(:, pos+1:698) = 1.0/neg;
    supp(:,1:pos) = faces_struct.images(:,labels);
    supp(:,pos+1:698) = faces_struct.images(:,~labels);
    stride(1) = pos;
    stride(2) = neg;
    
    db{1}.stride = stride;
    db{1}.w = w;
    db{1}.supp = supp;

end
