% function for computing cost and centers given OT matrix and points
% k = num distributions
% db = struct array containing WB information
% OT = struct array containing optimal transport information for db
% supp = size of barycenter
% d = dimension of everything

function [barycenter, cost, old_cost] = wb_processing(OT, db, k, supp, d, old_barycenter)
cost = 0.0;
old_cost = 0.0;
barycenter = zeros(supp, d);


% get  barycenter

% vector to store total weights of points
weights = zeros(1,supp);

for t = 1:k
    % how many points to use
    num_points = db{1}.stride(t);
    start_point = sum(db{1}.stride(1:t-1));
    barycenter = barycenter + OT{1}{t}*db{1}.supp(:, start_point+1:start_point + num_points)';
    weights = weights + sum(OT{1}{t},2)';
end

barycenter = bsxfun(@rdivide,barycenter,weights(:));

% get total cost

for t = 1:k
    % how many points to use
    num_points = db{1}.stride(t);
    start_point = sum(db{1}.stride(1:t-1));
    for j=1:num_points
        
        for s = 1:supp
            if OT{1}{t}(s,j) > eps
                cost = cost + OT{1}{t}(s,j)*norm( db{1}.supp(:, start_point + j) - barycenter(s,:)')^2;
            end
        end
        
    
    end
    
end

for t = 1:k
    % how many points to use
    num_points = db{1}.stride(t);
    start_point = sum(db{1}.stride(1:t-1));
    for j=1:num_points
        
        for s = 1:supp
            if OT{1}{t}(s,j) > eps
                old_cost = old_cost + OT{1}{t}(s,j)*norm( db{1}.supp(:, start_point + j) - old_barycenter(s,:)')^2;
            end
        end
        
    
    end
    
end


end