import random

points = [0]*50000
points[49999]=50000

def uniform(points, numSamples):
    numPoints = len(points)
    out = []
    for i in range(numSamples):
        ind = random.randint(0, numPoints-1)
        out.append((points[ind],numPoints/numSamples))
    return out

def uniform(points, numSamples):
    numPoints = len(points)
    out = []
    for i in range(numSamples):
        ind = random.randint(0, numPoints-1)
        out.append((points[ind],numPoints/numSamples))
    return out

def importance(points, numSamples):
    numPoints = len(points)
    points.sort()
    out = []
    out.append((points[0],1))
    out.append((points[-1],1))
    for i in range(numSamples-2):
        ind = random.randint(0, numPoints-1)
        out.append((points[ind],numPoints/(numSamples-2)))
    return out

def evalCost(wPoints, query):
    total = 0
    numPoints = len(wPoints)
    for i in range(numPoints):
        total += wPoints[i][1]*abs(query-(wPoints[i][0]))
    return total

def actualCost(points, query):
    total = 0
    numPoints = len(points)
    for i in range(numPoints):
        total += abs(query-points[i])
    return total

def multiEvalCost(points, numReps, query, uniSamples, coreSamples):
    uniAvg = 0
    coreAvg = 0
    for i in range(numReps):
        uni = uniform(points, uniSamples)
        coreset = importance(points, coreSamples)
        uniAvg += evalCost(uni,query)/numReps
        coreAvg += evalCost(coreset,query)/numReps
    return (uniAvg,coreAvg)

def multiEvalAbsCost(points, numReps, query, uniSamples, coreSamples, accCost):
    uniAvg = 0
    coreAvg = 0
    for i in range(numReps):
        uni = uniform(points, uniSamples)
        coreset = importance(points, coreSamples)
        uniAvg += abs(accCost-evalCost(uni,query))/numReps
        coreAvg += abs(accCost-evalCost(coreset,query))/numReps
    return (uniAvg,coreAvg)

query = 1
numReps = 10
numSamples = 100
uniSamples = 1000
coreSamples = 10
accCost = actualCost(points, query)
results = multiEvalCost(points, numReps, query, uniSamples, coreSamples)
#results = multiEvalAbsCost(points, numReps, query, uniSamples, coreSamples, accCost)
uniCost = results[0]
coreCost = results[1]

print((uniCost, coreCost, accCost))
print(((uniCost/accCost-1)*100, (coreCost/accCost-1)*100))
