# from tkinter import font
import matplotlib
import matplotlib.pyplot as plt
# import seaborn as sns
import numpy as np
# matplotlib.rcParams['pdf.fonttype'] = 42
# matplotlib.rcParams['ps.fonttype'] = 42
import pandas as pd

fontsize = 40
# columns = ['instance', 'initial_employee','initial_value','algorithm','value']
plt.close('all')
df = pd.read_csv('utils/final_table.csv', names = ['instance','algorithm','objective'])
df = df.sort_values(by='instance')

BKS = pd.read_csv('utils/BKS.csv', names = ['instance','objective']).set_index('instance')
kick = pd.read_csv('utils/kick.csv', names = ['instance','objective']).set_index('instance')
crossover = pd.read_csv('utils/crossover.csv', names = ['instance','objective']).set_index('instance')
SA= pd.read_csv('utils/SA.csv', names = ['instance','objective']).set_index('instance')
BP= pd.read_csv('utils/BP.csv', names = ['instance','objective']).set_index('instance')
HC = pd.read_csv('utils/HC.csv', names = ['instance','objective']).set_index('instance')

lucas = pd.read_excel('utils/benchmark_results.xlsx', header=1)
SA_best = lucas[['best']]

bounds = lucas[['bound']]



TS_shift = df.loc[df['algorithm']=='solutions/TS_shift/'].set_index('instance')
TS_comb = df.loc[df['algorithm']=='solutions/TS_combination/'].set_index('instance')
AILS_FI = df.loc[df['algorithm']=='solutions/AILS_FS/'].set_index('instance')
# AILS_TS = df.loc[df['algorithm']=='solutions/AILS_TS/']
ILS_FI_RW_random = df.loc[df['algorithm']=='solutions/ILS_LS_RW_random/'].set_index('instance')
ILS_FI_LSMC_random = df.loc[df['algorithm']=='solutions/ILS_LS_LSMC_random/'].set_index('instance')
ILS_FI_better_random = df.loc[df['algorithm']=='solutions/ILS_LS_better_random/'].set_index('instance')
ILS_TS_RW_random = df.loc[df['algorithm']=='solutions/ILS_TS_RW_random/'].set_index('instance')
ILS_TS_LSMC_random = df.loc[df['algorithm']=='solutions/ILS_TS_LSMC_random/'].set_index('instance')
ILS_TS_better_random = df.loc[df['algorithm']=='solutions/ILS_TS_better_random/'].set_index('instance')
ILS_TS_LSMC_kick = df.loc[df['algorithm']=='solutions/ILS_TS_LSMC_kick/'].set_index('instance')
ILS_TS_LSMC_crossover = df.loc[df['algorithm']=='solutions/ILS_TS_LSMC_crossover/'].set_index('instance')

# MEANS
AILS_FI_mean = AILS_FI.groupby(['instance']).mean()
# AILS_TS_mean = AILS_TS.groupby(['instance']).mean()
ILS_FI_RW_random_mean = ILS_FI_RW_random.groupby(['instance']).mean()
ILS_FI_LSMC_random_mean = ILS_FI_LSMC_random.groupby(['instance']).mean()
ILS_FI_better_random_mean = ILS_FI_better_random.groupby(['instance']).mean()
ILS_TS_RW_random_mean = ILS_TS_RW_random.groupby(['instance']).mean()
ILS_TS_LSMC_random_mean = ILS_TS_LSMC_random.groupby(['instance']).mean()
ILS_TS_LSMC_kick_mean = ILS_TS_LSMC_kick.groupby(['instance']).mean()
ILS_TS_LSMC_crossover_mean = ILS_TS_LSMC_crossover.groupby(['instance']).mean()
ILS_TS_better_random_mean = ILS_TS_better_random.groupby(['instance']).mean()

# BEST
# AILS_FI_mean = AILS_FI.groupby(['instance']).min()
# AILS_TS_mean = AILS_TS.groupby(['instance']).min()
ILS_TS_RW_random_mean = ILS_TS_RW_random.groupby(['instance']).min()
ILS_better_random_mean = ILS_TS_better_random.groupby(['instance']).min()

# GAP
SA[['GAP']] = (SA[['objective']] - BKS[['objective']][0:50])/BKS[['objective']][0:50]*100
BP[['GAP']] = (BP[['objective']] - BKS[['objective']][0:50])/BKS[['objective']][0:50]*100
HC[['GAP']] = (HC[['objective']] - BKS[['objective']][0:50])/BKS[['objective']][0:50]*100
TS_shift[['GAP']] = (TS_shift[['objective']] - BKS[['objective']] )/BKS[['objective']]*100
TS_comb[['GAP']] = (TS_comb[['objective']] - BKS[['objective']] )/BKS[['objective']]*100
AILS_FI_mean[['GAP']] = ( AILS_FI_mean[['objective']] - BKS[['objective']] )/BKS[['objective']]*100
ILS_FI_better_random_mean[['GAP']] = (ILS_FI_better_random_mean[['objective']] - BKS[['objective']] )/ BKS[['objective']]*100 
ILS_TS_better_random_mean[['GAP']] = (ILS_TS_better_random_mean[['objective']] - BKS[['objective']] )/ BKS[['objective']]*100 
ILS_TS_LSMC_random_mean[['GAP']] = (ILS_TS_LSMC_random_mean[['objective']]- BKS[['objective']] )/ BKS[['objective']]*100 
ILS_TS_LSMC_kick_mean[['GAP']] = (ILS_TS_LSMC_kick_mean[['objective']] - BKS[['objective']] )/BKS[['objective']]*100
ILS_TS_LSMC_crossover_mean[['GAP']] = (ILS_TS_LSMC_crossover_mean[['objective']] - BKS[['objective']] )/BKS[['objective']]*100
ILS_FI_RW_random_mean[['GAP']] = (ILS_FI_RW_random_mean[['objective']] - BKS[['objective']] ) /BKS[['objective']]*100
ILS_TS_RW_random_mean[['GAP']] = (ILS_TS_RW_random_mean[['objective']] - BKS[['objective']] )/BKS[['objective']]*100

instances = np.arange(1,66)

###################################################################################################### 
# TS COMPARISON

# plt.figure()
# # plt.plt.plot(instances, TS_shift[[ob]])
# plt.plot(range(50), TS_shift[['objective']][0:50], 'o', label='TS')
# plt.plot(range(50), HC[['objective']], 'o', label='HC')
# plt.plot(range(50), BP[['objective']], 'o', label='BP')
# plt.plot(range(50), SA[['objective']], 'o', label='SA')
# # plt.plot(instances, TS_shift[['objective']], 'o', label='TS Shift')
# # plt.plot(instances, TS_comb[['objective']], 'D', label='TS Combination')
# # # [TS_shift[['objective']], TS_shift[['objective']]].plot.bar()
# plt.xlabel('instance', fontsize=fontsize)

# plt.ylabel('objective', fontsize=fontsize)
# plt.legend(fontsize=fontsize)
# plt.grid(True)

# plt.figure()
# plt.plot(range(50), TS_shift[['GAP']][0:50], 'o', label='TS')
# plt.plot(range(50), HC[['GAP']], 'o', label='HC')
# plt.plot(range(50), BP[['GAP']], 'o', label='BP')
# plt.plot(range(50), SA[['GAP']], 'o', label='SA')
# # plt.plot(instances, TS_shift[['objective']], 'o', label='TS Shift')
# # plt.plot(instances, TS_comb[['objective']], 'D', label='TS Combination')
# # # [TS_shift[['objective']], TS_shift[['objective']]].plot.bar()
# plt.xlabel('instance', fontsize=fontsize)

# plt.ylabel('objective', fontsize=fontsize)
# plt.legend(fontsize=fontsize)
# plt.grid(True)

# plt.figure()
# plt.ylabel('GAP (%)', fontsize=fontsize)
# boxplot = pd.merge(TS_shift[['GAP']], TS_comb[['GAP']], on='instance', suffixes=('_shift', '_comb'))
# boxplot = boxplot.rename(columns={'GAP_shift':"Shift", "GAP_comb":"Combination"})
# boxplot.boxplot(fontsize=fontsize)


# ###################################################################################################### 
# # PERTURBATION COMPARISON
# plt.ylabel('GAP (%)', fontsize=fontsize)       
# # boxplot = pd.merge(ILS_TS_LSMC_kick_mean[['GAP']], ILS_TS_LSMC_crossover_mean[['GAP']], on='instance')
# # boxplot = boxplot.rename(columns= {'GAP_x': 'kick', 'GAP_y':'crossover'})

# ILS_TS_LSMC_kick_mean = ILS_TS_LSMC_kick_mean.rename(columns={'GAP':'kick'})
# ILS_TS_LSMC_kick_mean[['crossover']] = ILS_TS_LSMC_crossover_mean[['GAP']]
# ILS_TS_LSMC_kick_mean[['shift']] = ILS_TS_LSMC_random_mean[['GAP']]
# print(ILS_TS_LSMC_kick_mean.columns)
# ILS_TS_LSMC_kick_mean.boxplot(column = ['kick','shift','crossover'],fontsize=fontsize)
# # boxplot = pd.merge(boxplot, ILS_TS_LSMC_random_mean[['GAP']], on='instance')
# boxplot.boxplot(fontsize=fontsize############################################################################# 
# # PERTURBATION COMPARISON
# plt.ylabel('GAP (%)', fontsize=fontsize)       
# boxplot = pd.merge(ILS_TS_LSMC_kick_mean[['GAP']], ILS_TS_LSMC_crossover_mean[['GAP']], on='instance')
# boxplot = pd.merge(boxplot, ILS_TS_LSMC_random_mean[['GAP']], on='instance')
# boxplot = boxplot.rename(columns= {'GAP_x': 'kick', 'GAP_y':'crossover','GAP':'shift'})
# boxplot.boxplot(fontsize=fontsize############################################################################# 
# # PERTURBATION COMPARISON
# plt.ylabel('GAP (%)', fontsize=fontsize)       
# boxplot = pd.merge(ILS_TS_LSMC_kick_mean[['GAP']], ILS_TS_LSMC_crossover_mean[['GAP']], on='instance')
# boxplot = pd.merge(boxplot, ILS_TS_LSMC_random_mean[['GAP']], on='instance')
# boxplot = boxplot.rename(columns= {'GAP_x': 'kick', 'GAP_y':'crossover','GAP':'shift'})
# boxplot.boxplot(fontsize=fontsize############################################################################# 
# # PERTURBATION COMPARISON
# plt.ylabel('GAP (%)', fontsize=fontsize)       
# boxplot = pd.merge(ILS_TS_LSMC_kick_mean[['GAP']], ILS_TS_LSMC_crossover_mean[['GAP']], on='instance')
# boxplot = pd.merge(boxplot, ILS_TS_LSMC_random_mean[['GAP']], on='instance')
# boxplot = boxplot.rename(columns= {'GAP_x': 'kick', 'GAP_y':'crossover','GAP':'shift'})
# boxplot.boxplot(fontsize=fontsize)
# print(boxplot.columns)
# boxplot = boxplot.rename(columns={'GAP_x':"kick", 'GAP_y':"crossover","GAP":"random"})
# boxplot.boxplot()
# boxplot = pd.merge(kick[['GAP']], crossover[['GAP']], on='instance')
# boxplot = pd.merge(boxplot, ILS_TS_LSMC_random_mean[['GAP']], on='instance')
# boxplot = boxplot.rename(columns={'GAP_x':"Kick", 'GAP_y':"Crossover"})
# boxplot.boxplot(fontsize=fontsize)



plt.figure()
# N = 10
labels = ['1', '2', '3', '4', '5', '6', '7', '8', '9','10']
BP = [14709.2, 30294.8,49846.4,67000.4,84341.0,99727.0,118524.2,134513.8,150370.8,172582.2]
HC = [14988.4,31275.6,51917.3,71337.6,87262.5,104296.2,123303.8,140508.0,156862.5,172909.0]
SA = [14739.6,30970.8,51257.8,69379.9,87557.3,104333.1,123225.6,140913.8,157426.0,174501.6]
TS = [15036.4,31248.4,51483.0,69941.2,87850.6,104926.2,123632.2,140482.4,156296.4,172916.0]
ILS = [14900.0,31158.0,51603.0,70238.6,88130.1,105440.1,123976.2,141250.3,157216.7,173587.4]

x = np.arange(len(labels))
width = 0.15  # the width of the bars
rects1 = plt.bar(x - width, BP, width, label='BP')
rects2 = plt.bar(x, HC, width, label='HC')
rects2 = plt.bar(x + width, SA, width, label='SA')
rects2 = plt.bar(x + width*2, TS, width, label='TS')
rects2 = plt.bar(x+width*3, ILS, width, label='ILS' )
plt.ylabel('Objective',fontsize=fontsize)
plt.xticks(x+width,labels,fontsize=fontsize)
# plt.title('Comparison of objectives',fontsize=fontsize)
plt.xlabel('Size',fontsize=fontsize)
plt.legend(fontsize=fontsize)

plt.figure()


# plt.grid(True)
# ax.bar_label(rects1, padding=3)
# fig.tight_layout()
###################################################################################################### 
## DOES LSMC (Tuned) OUTPERFORM RW AND BETTER?

# plt.figure()


# plt.plot(instances, ILS_TS_RW_random_mean[['objective']], 'o', label='RW')
# plt.plot(instances, ILS_TS_LSMC_random_mean[['objective']], 'D', label='LSMC')
# plt.plot(instances, ILS_TS_better_random_mean[['objective']], 'x', label='Better')

# plt.xlabel('instance', fontsize=fontsize)
# plt.ylabel('objective', fontsize=fontsize)
# plt.legend()
# plt.grid(True)


# plt.figure()

# my_list = [ILS_TS_RW_random_mean, ILS_TS_better_random_mean, ILS_TS_LSMC_random_mean]
# for i in range(3):
#     if i == 0:
#         boxplot = my_list[0]
#     else:
#         boxplot = pd.merge(
#             boxplot,
#             my_list[i],
#             on='instance'
#         )

# plt.ylabel('GAP (%)', fontsize=fontsize)       
# # boxplot = boxplot['GAP_x','GAP_y','GAP'] 
# # # sns.boxplot(data=my_list)
# # boxplot.rename(columns= {'GAP_x': 'RW'})
# # print(boxplot.columns)
# boxplot = boxplot.rename(columns={'GAP_x':"RW", 'GAP_y':"Better","GAP":"LSMC"})
# boxplot.boxplot(column = ['RW','Better','LSMC'], fontsize=fontsize)


###################################################################################################### 
## DOES ADAPTIVE PERTURBATIONS OUTPERFORM STATIC ONES?

# plt.figure()
# plt.subplot(2, 1, 1)
# plt.title('Do adaptive perturbations outperform static ones?')
# # # # Using Numpy to create an array X
# plt.plot(instances, AILS_FI_mean[['objective']], 'o', label='Adaptive', )
# plt.plot(instances, ILS_FI_LSMC_random_mean[['objective']], 'x', label='ILS', )

# # # Naming the x-axis, y-axis and the whole graph
# plt.ylabel('objective', fontsize=fontsize)
# # Adding legend, which helps us recognize the curve according to it's color
# plt.legend()

# plt.grid(True)

# plt.subplot(2, 1, 2)
# pd.merge(AILS_FI_mean[['GAP']], ILS_FI_LSMC_random_mean[['GAP']], on='instance',suffixes=('_adaptive', '_ILS')).boxplot()
# plt.ylabel('GAP (%)', fontsize=fontsize) 

###################################################################################################### 
## IS IT WORTH TO USE TABU SEARCH INSTEAD OF FIRST IMPROVEMENT?



# plt.ylabel('GAP (%)', fontsize=fontsize)   

# ILS_FI_RW_random_mean = ILS_FI_RW_random_mean.rename(columns={'GAP':'FI'}) 
# ILS_FI_RW_random_mean[['TS']] = ILS_TS_RW_random_mean[['GAP']]   
# ILS_FI_RW_random_mean.boxplot(column=['FI','TS'],fontsize=fontsize)
# # boxplot = boxplot.rename(columns= {'GAP_x': 'kick', 'GAP_y':'crossover'})

# ILS_TS_LSMC_kick_mean = ILS_TS_LSMC_kick_mean.rename(columns={'GAP':'kick'})
# ILS_TS_LSMC_kick_mean[['crossover']] = ILS_TS_LSMC_crossover_mean[['GAP']]
# ILS_TS_LSMC_kick_mean[['shift']] = ILS_TS_LSMC_random_mean[['GAP']]
# print(ILS_TS_LSMC_kick_mean.columns)
# ILS_TS_LSMC_kick_mean.boxplot(column = ['kick','shift','crossover'],fontsize=fontsize)

# # boxplot = pd.merge(ILS_TS_LSMC_kick_mean[['GAP']], ILS_TS_LSMC_crossover_mean[['GAP']], on='instance')
# # boxplot = boxplot.rename(columns= {'GAP_x': 'kick', 'GAP_y':'crossover'})

# ILS_TS_LSMC_kick_mean = ILS_TS_LSMC_kick_mean.rename(columns={'GAP':'kick'})
# ILS_TS_LSMC_kick_mean[['crossover']] = ILS_TS_LSMC_crossover_mean[['GAP']]
# ILS_TS_LSMC_kick_mean[['shift']] = ILS_TS_LSMC_random_mean[['GAP']]
# print(ILS_TS_LSMC_kick_mean.columns)
# ILS_TS_LSMC_kick_mean.boxplot(column = ['kick','shift','crossover'],fontsize=fontsize)
# # boxplot = pd.merg

# To load the display window


# plt.figure()
# plt.subplot(2, 3, 1)
# plt.title('RW')
# plt.plot(instances, ILS_FI_RW_random_mean[['objective']], 'o', label='FI')
# plt.plot(instances,ILS_TS_RW_random_mean[['objective']], 'x', label='TS') 


# plt.ylabel('objective', fontsize=fontsize)
# plt.legend()
# plt.grid(True)


# plt.subplot(2, 3, 2)

# plt.legend()
# plt.title('Better')
# plt.grid(True)
# plt.plot(instances, ILS_FI_better_random_mean[['objective']], 'o', label='FI')
# plt.plot(instances,ILS_TS_better_random_mean[['objective']], 'x', label='TS') 

# plt.subplot(2, 3, 3)

# plt.legend()
# plt.title('LSMC')
# plt.grid(True)
# plt.plot(instances, ILS_FI_LSMC_random_mean[['objective']], 'o', label='FI')
# plt.plot(instances,ILS_TS_LSMC_random_mean[['objective']], 'x', label='TS') 


# plt.subplot(2, 3, 4)
# plt.ylabel('GAP (%)', fontsize=fontsize)   
# boxplot = pd.merge(ILS_FI_RW_random_mean[['GAP']], ILS_TS_RW_random_mean[['GAP']], on='instance')
# boxplot = pd.merge(boxplot, BP[['GAP']], on='instance')
# boxplot = boxplot.rename(columns={'GAP_x':"FI", 'GAP_y':"TS", 'GAP':'BP'})
# boxplot.boxplot(column = [],fontsize=fontsize)
# plt.ylabel('GAP (%)', fontsize=fontsize)  

# plt.subplot(2, 3, 5)
# pd.merge(ILS_FI_better_random_mean[['GAP']], ILS_TS_better_random_mean[['GAP']], on='instance').boxplot()

# plt.subplot(2, 3, 6)
# pd.merge(ILS_FI_LSMC_random_mean[['GAP']], ILS_TS_LSMC_random_mean[['GAP']], on='instance').boxplot()

# color = {
#     "boxes": "DarkGreen",
#     "whiskers": "DarkOrange",
#     "medians": "DarkBlue",
#     "caps": "Gray",
# }
# plt.figure();

# # ILS_RW_random_mean[['objective']].plot.box(color=color)
# # ILS_better_random_mean[['objective']].plot.box(color=color)
# # ILS_better_random.boxplot(by='instance')

# TS_shift[['GAP']] = (TS_shift[['objective']] - BKS[['objective']] )/BKS[['objective']]*100
# # TS_shift[['GAP']].boxplot()
# ILS_TS_RW_random_mean[['GAP']] = (ILS_TS_RW_random_mean[['objective']] - BKS[['objective']] )/BKS[['objective']]*100
# # ILS_RW_random_mean.boxplot(column='GAP')
# # TS_comb[['GAP']] = (TS_comb[['objective']] - BKS[['objective']] )/BKS[['objective']]*100
# # TS_comb[['GAP']].boxplot()
# # boxplot = pd.merge(TS_shift,ILS_RW_random_mean, on='instance').boxplot(column=['GAP_x','GAP_y'])

# plt.xlabel('instance', fontsize=fontsize)
# plt.ylabel('objective', fontsize=fontsize)




# plt.figure()
# # plt.ylabel('GAP (%)', fontsize=fontsize)   

# X = np.arange(1, 51)
# plt.ylabel('GAP (%)', fontsize=fontsize)  
# SA = SA.rename(columns={'GAP':'SA'})
# # SA[['ILS']] =  ILS_TS_RW_random_mean[['GAP']][0:50]
# SA[['TS']] = TS_shift[['GAP']][0:50]
# SA[['HC']] = HC[['GAP']]
# SA[['BP']] = BP[['GAP']]

# SA.boxplot(column =['SA','TS','HC','BP','ILS'], fontsize=fontsize)
# boxplot = pd.merge(SA[['GAP']], ILS_TS_RW_random_mean[['GAP']][0:50], on='instance')
# boxplot = pd.merge(boxplot, HC[['GAP']], suffixes=['prova'],on='instance')
# boxplot = pd.merge(boxplot, BP[['GAP']], on='instance')
# print(final.columns)
# boxplot = boxplot.rename(columns={'GAP_x':"SA", 'GAP_y':"ILS", 'GAP_x':'HC'})
# boxplot.boxplot(fontsize=fontsize30)
# # plt.title('ICAPS instances')
# plt.plot(X, TS_shift[['objective']][:50], 'x', label='TS Shift' )
# # plt.plot(X, AILS_FI_mean[['objective']][:50], 'v', label='AILS FI' )
# # plt.plot(X, AILS_FI_mean[['objective']][:50], 's', label='AILS TS' )
# # plt.plot(X, ILS_FI_RW_random_mean[['objective']][:50], 'D', label='ILS FI RW random')
# plt.plot(X, ILS_TS_RW_random_mean[['objective']][:50], 'v', label='ILS TS RW random')
# # plt.plot(X, ILS_better_random_mean[['objective']][:50], '^', label='ILS TS better random')
# plt.plot(X, SA_mean, 'o', label='SA')
# plt.plot(X, bounds, 'o-', label='lower bounds')

# plt.ylabel('objective', fontsize=fontsize)
# plt.xlabel('instance', fontsize=fontsize)
# plt.grid(True)
# plt.legend()


plt.show()