from collections import defaultdict
import csv

instances = defaultdict(list) # Instantiate a dictionary with list as elements' type

with open('final_summary.csv', 'r', newline='') as f:    
    for line in f:
        x = line.split(',')
        x[-1].strip()
        instances[x[0]].append(x[2:-2] + [x[-1].strip()]) 

with open('result_table.csv', 'w') as f:
    writer = csv.writer(f)
    for key, value in instances.items():
        writer.writerow([key]+ [item for sublist in value for item in sublist])
