import datetime
import os


from data import Solution


class OutputWriter():

    def __init__(self, instance_file: str, stats) -> None:
        self.instance_file = instance_file
        self.stats = stats

    def create_output_directory(self) -> None:
        """Create the output directory if it does not exist."""
        directory = f'experiments/{datetime.date.today()}/{self.instance_file}'
        if not os.path.exists(directory):
            os.makedirs(directory)
        self.directory = f'{directory}.csv'

    def write_trajectory(self, solution: Solution) -> None:
        """Write the solution to the output file.

        Parameters
        ----------
        solution : Solution
            Solution to write
        stats : Stats
            Statistics
        """

        with open(self.directory, 'w') as f:
            f.write(f'{self.stats.get_used_walltime()},{solution.value}\n')


    # def write_STN(self, solution: Solution) -> None:
    #     """Write the solution to the output file.

    #     Parameters
    #     ----------
    #     solution : Solution
    #         Solution to write
    #     """

    #     with open(f'experiments/alns/{self.instance_file}', 'w') as f:
    #         f.write(solution.value)