The `main.py` file contains the code for the main experiments. It can split the data set into chunks for 'embarrassingly parallel' execution.
For example to run a targeted test for GSE and a ResNet20 on images 1000-1999 of the CIFAR10 test set with a batch size of 500, execute 
`python main.py --dataset 'CIFAR10' --model 'ResNet20' --numchunks 10 --chunk 1 --batchsize 500 --attack 'GSE' --targeted 1`.

The `run.sh` file runs all experiments (not parallelized) as background processes and processes the results once all experiments have finished.
Due to file size constraints, this archive does not contain the weights for a ResNet50 CAM. Hence `run.sh` does not generate the images for Figure 3.
Before executing `run.sh`, you need to add images for generating Figure 4 in `./Images` and update `generate_examples.py` accordingly.

Dependencies: `numpy`, `torch`, `torchvision`, `natsort`, `pandas`, `matplotlib`, `skimage`
