from typing import Any, Optional


class Entity:
    def __init__(self, id: Any, x: int, y: int):
        self.id = id
        self.x = x
        self.y = y


class Agent(Entity):
    def __init__(
        self,
        id: Any,
        x: int,
        y: int,
        n_objectives: int,
        max_load: Optional[int] = 2,
    ):
        super().__init__(id, x, y)
        self.max_load = max_load
        self.curr_load = 0
        self.bag = [0 for _ in range(n_objectives)]
        self.beliefs = {}


class Plate(Entity):
    def __init__(self, id: Any, x: int, y: int):
        super().__init__(id, x, y)
        self.pressed = False
        self.pressing_agent = None


class Door(Entity):
    def __init__(self, id: Any, x: int, y: int):
        super().__init__(id, x, y)
        self.open = False


class Wall(Entity):
    def __init__(self, id: Any, x: int, y: int):
        super().__init__(id, x, y)


class Goal(Entity):
    def __init__(self, id: Any, x: int, y: int):
        super().__init__(id, x, y)
        self.achieved = False
