# Fairness in Cooperative Multiagent Multiobjective Reinforcement Learning using the Expected Scalarized Reward Criterion (Supplementary Material)

This folder contains a pdf file describing the appendices of the paper along with the code used to generate the results presented in the paper.
## Setup for using the code 
Note that the python version used to develop and run this solution is `python3.10`.
- In a new folder, create a virtual environment using venv by executing the following command `python3 -m venv my_env`.
- Activate the environment by running the command `source my_env/bin/activate`.
- Install the required packages to run the code with the command `pip install -r requirements.txt` 
- Add the current directory to the pythonPath with the command `export PYTHONPATH="$PWD"`.
- Unzip the `results` folder. 
## Using the code 
The code can be used in two possible ways:
- Generate the plots from the provided data using the `visualize_results.py` file given a `results` folder: In that case you will need to provide the `visualize_results.py` with 2 arguments: the environment you want the results to be taken out either `resource_gathering_small_uniform_2a_2r` or `resource_gathering_small_uniform_3a_3r` and the metric you want to track either `prop` or `ep_length`. For example, running the command `python3.10 visualize_results.py resource_gathering_small_uniform_2a_2r ep_length`. 
     
- Running the experiments used to learn policies and tracking their progress on weights and Biases using the files in the folder `experiments/ResourceGathering`: (MAKE SURE TO SAVE THE RESULTS FOLDER BEFORE RUNNING THE COMMANDS IN THIS SECTION) 

    In this case you will have to run the command `python3.10 experiments/ResourceGathering/test_centralized <seed>` or `python3.10 experiments/ResourceGathering/test_decentralized <seed>` and change the `<seed>` argument with the seed you want to use to initialize the environment. The results used in the paper were generated using the values 0,1,2,3 and 4 for the seed values. Note that for the logging on weights and biases to work you will have to login with your first weights and biases account and input your API key.    
 
    
