
# FSW-GNN: A Bi-Lipschitz WL-Equivalent Graph Neural Network

This readme explains how to reproduce the experiments from the anonymous paper **FSW-GNN: A Bi-Lipschitz WL-Equivalent Graph Neural Network**.

To set up the environment, run the following commands: 
conda create --name oversquash -c conda-forge python=3.11 
conda activate oversquash 
pip3 install torch torchvision torchaudio 
pip install torch_geometric 
pip install pytorch-lightning 
pip install easydict 
pip install type_enforced 
pip3 install -U scikit-learn

Choose a dataset name from `Ring`, `CrossRing`, `CliqueRing`, or `Tree` and denote it as `name`. For `Tree`, choose a radius in the range 2 to 8, and for other datasets, choose a radius in the range 2 to 15, denoted as `r`. Then, run the following commands: 
cd bottleneck_script 
python train.py --dataset_name name --radius r 
This will display the accuracy and the energy of the model.

For real-world tasks, follow the same Conda setup as above. Choose a dataset name from: `Cora`, `Cite`, `Pubm`, `Cham`, `Squi`, `Actor`, `Corn`, `Texas`, `Wisc`, and denote it as `name`. Then, run the following command: 
python train.py --dataset_name name 
This will display the accuracy over 10 seeds and the energy.

For LRGB and MolHIV experiments, follow the Conda installation instructions from the [GraphGPS repository](https://github.com/rampasek/GraphGPS/tree/main). Navigate to the `lrgb` directory: 
cd lrgb

To run experiments for **LRGB functional tasks**, run the following: 
python main.py --cfg configs/LRGB-tuned/peptides-func-fsw.yaml name_tag func_running

To run experiments for **LRGB structural tasks**, run the following: 
python main.py --cfg configs/LRGB-tuned/peptides-struct-fsw.yaml name_tag struct_running

To run experiments for **MolHIV**, run the following: 
python main.py --cfg configs/LRGB-tuned/MolHIV-fsw.yaml name_tag MolHIV_running
