#! /bin/bash
# This bash script builds the fsw_embedding.so CUDA library accompanying the main python library fsw_embedding.py

CUDA_HOME=/usr/local/cuda

# Check if the CUDA home directory exists
if [ -d "$CUDA_HOME" ]; then
    echo "CUDA home directory: $CUDA_HOME"
else
    echo "Error: CUDA home directory does not exist: $CUDA_HOME" >&2
    exit 1
fi

printf "Building... "

"$CUDA_HOME/bin/nvcc" -shared -o libfsw_embedding.so -O3 --compiler-options '-O3 -fPIC' fsw_embedding.cu -Wno-deprecated-gpu-targets \
    -gencode arch=compute_50,code=sm_50 \
    -gencode arch=compute_52,code=sm_52 \
    -gencode arch=compute_60,code=sm_60 \
    -gencode arch=compute_61,code=sm_61 \
    -gencode arch=compute_70,code=sm_70 \
    -gencode arch=compute_75,code=sm_75 \
    -gencode arch=compute_80,code=sm_80 \
    -gencode arch=compute_86,code=sm_86

printf "done\n\n"
