<p align="center">
  <img src="./assets/toolfuzz.png" />
</p>

# 🕵️ ToolFuzz - Automated Testing for Agent Tools

## What is ToolFuzz?

**ToolFuzz** is the **first-ever** framework designed to rigorously test the correctness and robustness of
**LLM agent tools**.
Combining advanced fuzzing techniques and LLMs, with sophisticated correctness evaluation, ToolFuzz dynamically
generates a vast range of test prompts, ensuring your tools can handle real-world scenarios.

## Why ToolFuzz?

With ToolFuzz, you can push your agent tools to their limits and identify critical weaknesses before they impact
performance. It seamlessly integrates into your agent setup to detect:

✅ **Runtime Tool Failures** – Find prompts which lead to unexpected crashes.  
✅ **Incorrect Tool Outputs** – Find prompts which lead to wrong responses.

## Environment set up and development

We use conda for virtual environment setup. There are two setups `minimal_environment.yml` and `environment.yml`.
The `minimal_environment.yml` contains only the core (for the toolfuzz package) requirements with just langchain, while
the `environment.yml` contains the dependencies for all intergrations.

You can setup either of them by:

```bash
conda env create --name toolfuzz --file=ENV_FILE.yml
conda activate toolfuzz
```

## Evaliation

All the evalutiona scripts are located in the `src/eval` folder. Each folder there has its own README.md on how to run the scripts.