import csv
import json
import os
import random

dir_to_scan = './corr_white_comp'

data_to_label = []

for file in os.listdir(dir_to_scan):
    with open(dir_to_scan + '/' + file, 'r') as f:
        data = json.load(f)
    # Now sample 10 prompt sets:
    samples = 10 if len(data) > 10 else len(data)
    print(file, len(data))
    new_data = random.sample(data, samples)
    for item in new_data:
        item['tool'] = file.split('res_bl_wh_')[1].split('_over_budget.json')[0]
    data_to_label += new_data

csv_columns = ['id', 'tool', 'Prompt', 'ToolArgs', 'ToolOutput', 'AgentResponse', 'LLMScore' ]


i = 0
rows = []
for item in data_to_label:
    row = {}
    row['id'] = i
    row['tool'] = item['tool']
    row['Prompt'] = item['prompt']
    row['ToolOutput'] = item['tool_output']
    row['AgentResponse'] = item['agent_output']
    row['ToolArgs'] = item['tool_arguments']
    row['LLMScore'] = item['unexpected_agent_output']
    rows.append(row)
    i+=1

with open('wh_comp_to_label.csv', 'w', newline='') as csvfile:
    writer = csv.DictWriter(csvfile, fieldnames=csv_columns)
    writer.writeheader()
    for row in rows:
        writer.writerow(row)