import os
import json


def read_evals(eval_files, number):
    data = []
    for file in eval_files:
        with open(file, 'r') as f:
            data += json.loads(f.read())
    num_succ = len([d for d in data if d['success']])
    num_error = len([d for d in data if not d['success']])
    pass_rate = num_succ/len(data)
    print(f"Prompt {number}: {num_succ} successful, {num_error} errors, {len(data)} total, {num_succ/len(data)*100:.2f}% pass rate")
    return pass_rate

def read_defs():
    files = os.listdir('./')
    pass_rate = 0
    prompt_prefix = []
    for subset in range(1, 5):
        prefix = f"eval_terminal_{subset}_def_results_"
        filtered_files = [file for file in files if file.startswith(prefix)]
        prompt_prefix += filtered_files
    print(f"Default pass rate: {pass_rate*100:.2f}%")

def get_env_files():
    files = os.listdir('./')
    pass_rate = 0
    for prompt in range(20):
        prompt_prefix = []
        for subset in range(1, 5):
            prefix = f"eval_terminal_{subset}_{prompt}_results_"
            filtered_files = [file for file in files if file.startswith(prefix)]
            prompt_prefix += filtered_files
        pass_rate += read_evals(prompt_prefix, prompt)
    print(f"Total pass rate: {pass_rate/19*100:.2f}%")


get_env_files()

read_defs()