
# Root directory
ROOT_DIR=${1}

mkdir -p $ROOT_DIR

# Create client folders, years, document types, and quarterly tax folders explicitly
for client in client_A client_B; do
  for year in 2023 2024; do
    mkdir -p "$ROOT_DIR/clients/$client/$year/financial_statements"
    mkdir -p "$ROOT_DIR/clients/$client/$year/invoices"
    mkdir -p "$ROOT_DIR/clients/$client/$year/payroll"
    for quarter in Q1 Q2 Q3 Q4; do
      mkdir -p "$ROOT_DIR/clients/$client/$year/tax/$quarter"
    done
  done
done

# Create reports folders
mkdir -p "$ROOT_DIR/reports/annual_reports"
mkdir -p "$ROOT_DIR/reports/monthly_reports"
mkdir -p "$ROOT_DIR/reports/quarterly_reports"

# Create templates folders
mkdir -p "$ROOT_DIR/templates/invoice_templates"
mkdir -p "$ROOT_DIR/templates/payroll_templates"
mkdir -p "$ROOT_DIR/templates/tax_templates"

# Create archive folders
mkdir -p "$ROOT_DIR/archive/clients"
mkdir -p "$ROOT_DIR/archive/reports"
mkdir -p "$ROOT_DIR/archive/templates"

# Add dummy files in client folders
for client in client_A client_B; do
  for year in 2023 2024; do
    # Financial Statements
    touch "$ROOT_DIR/clients/$client/$year/financial_statements/balance_sheet.pdf"
    touch "$ROOT_DIR/clients/$client/$year/financial_statements/profit_loss_statement.pdf"
    
    # Invoices
    touch "$ROOT_DIR/clients/$client/$year/invoices/invoice_001.pdf"
    touch "$ROOT_DIR/clients/$client/$year/invoices/invoice_002.pdf"
    
    # Payroll
    touch "$ROOT_DIR/clients/$client/$year/payroll/employee_payroll_jan.csv"
    touch "$ROOT_DIR/clients/$client/$year/payroll/employee_payroll_feb.csv"

    # Tax by Quarter
    for quarter in Q1 Q2 Q3 Q4; do
      touch "$ROOT_DIR/clients/$client/$year/tax/$quarter/tax_filing.pdf"
      touch "$ROOT_DIR/clients/$client/$year/tax/$quarter/tax_receipt.pdf"
    done
  done
done

# Add dummy files in reports folders
touch "$ROOT_DIR/reports/annual_reports/annual_report_2023.pdf"
touch "$ROOT_DIR/reports/monthly_reports/january_2023.pdf"
touch "$ROOT_DIR/reports/monthly_reports/february_2023.pdf"
touch "$ROOT_DIR/reports/quarterly_reports/Q1_report_2023.pdf"
touch "$ROOT_DIR/reports/quarterly_reports/Q2_report_2023.pdf"

# Add dummy files in templates folders
touch "$ROOT_DIR/templates/invoice_templates/basic_invoice_template.docx"
touch "$ROOT_DIR/templates/invoice_templates/advanced_invoice_template.docx"
touch "$ROOT_DIR/templates/payroll_templates/monthly_payroll_template.xlsx"
touch "$ROOT_DIR/templates/payroll_templates/weekly_payroll_template.xlsx"
touch "$ROOT_DIR/templates/tax_templates/standard_tax_template.docx"
touch "$ROOT_DIR/templates/tax_templates/corporate_tax_template.docx"

# Add dummy files in archive folders
touch "$ROOT_DIR/archive/clients/archived_client_A_2021.zip"
touch "$ROOT_DIR/archive/clients/archived_client_B_2021.zip"
touch "$ROOT_DIR/archive/reports/archived_annual_report_2021.pdf"
touch "$ROOT_DIR/archive/reports/archived_monthly_report_2021.pdf"
touch "$ROOT_DIR/archive/templates/old_invoice_template.docx"
touch "$ROOT_DIR/archive/templates/old_payroll_template.xlsx"

###############################################################################################################
# "Retrieve all Q1 2023 reports, both monthly and quarterly, and copy them to a new 'Quarter 1 Reports' folder."
#  Some steps that give this state
###############################################################################################################

mkdir "$ROOT_DIR/Quarter 1 Reports"

cp "$ROOT_DIR/reports/monthly_reports/january_2023.pdf" "$ROOT_DIR/Quarter 1 Reports/"
cp "$ROOT_DIR/reports/monthly_reports/february_2023.pdf" "$ROOT_DIR/Quarter 1 Reports/"
cp "$ROOT_DIR/reports/quarterly_reports/Q1_report_2023.pdf" "$ROOT_DIR/Quarter 1 Reports/"

git config --global user.email "test@test.com"
git config --global user.name "Test Test"
git -C "$ROOT_DIR" init
git -C "$ROOT_DIR" add -A
git -C "$ROOT_DIR" commit -m "initial commit"
