#!/bin/bash

root_dir=$1

mkdir -p ${root_dir}/archive/products
mkdir -p ${root_dir}/archive/sales
mkdir -p ${root_dir}/archive/templates

mkdir -p ${root_dir}/products/product_A/2023/product_images
mkdir -p ${root_dir}/products/product_A/2023/product_reviews
mkdir -p ${root_dir}/products/product_A/2023/sales/Q1
mkdir -p ${root_dir}/products/product_A/2023/sales/Q2
mkdir -p ${root_dir}/products/product_A/2023/sales/Q3
mkdir -p ${root_dir}/products/product_A/2023/sales/Q4

mkdir -p ${root_dir}/products/product_A/2024/product_images
mkdir -p ${root_dir}/products/product_A/2024/product_reviews
mkdir -p ${root_dir}/products/product_A/2024/sales/Q1
mkdir -p ${root_dir}/products/product_A/2024/sales/Q2
mkdir -p ${root_dir}/products/product_A/2024/sales/Q3
mkdir -p ${root_dir}/products/product_A/2024/sales/Q4

mkdir -p ${root_dir}/products/product_B/2023/product_images
mkdir -p ${root_dir}/products/product_B/2023/product_reviews
mkdir -p ${root_dir}/products/product_B/2023/sales/Q1
mkdir -p ${root_dir}/products/product_B/2023/sales/Q2
mkdir -p ${root_dir}/products/product_B/2023/sales/Q3
mkdir -p ${root_dir}/products/product_B/2023/sales/Q4

mkdir -p ${root_dir}/products/product_B/2024/product_images
mkdir -p ${root_dir}/products/product_B/2024/product_reviews
mkdir -p ${root_dir}/products/product_B/2024/sales/Q1
mkdir -p ${root_dir}/products/product_B/2024/sales/Q2
mkdir -p ${root_dir}/products/product_B/2024/sales/Q3
mkdir -p ${root_dir}/products/product_B/2024/sales/Q4

mkdir -p ${root_dir}/reports/annual_reports
mkdir -p ${root_dir}/reports/monthly_reports
mkdir -p ${root_dir}/reports/quarterly_reports

mkdir -p ${root_dir}/templates/product_description_templates
mkdir -p ${root_dir}/templates/sales_report_templates
mkdir -p ${root_dir}/templates/review_templates

# Create files

# Archive
touch ${root_dir}/archive/products/archive_note.txt
touch ${root_dir}/archive/sales/sales_archive_2023.csv
touch ${root_dir}/archive/templates/old_template.docx

# Product A 2023
touch ${root_dir}/products/product_A/2023/product_images/image1.jpg
touch ${root_dir}/products/product_A/2023/product_reviews/review1.txt
touch ${root_dir}/products/product_A/2023/sales/Q1/sales_data.csv

# Product B 2024
touch ${root_dir}/products/product_B/2024/product_images/image_b1.png
touch ${root_dir}/products/product_B/2024/product_reviews/review_b1.txt
touch ${root_dir}/products/product_B/2024/sales/Q4/sales_q4_b.csv

# Reports
touch ${root_dir}/reports/annual_reports/annual_2023.pdf
touch ${root_dir}/reports/monthly_reports/jan_report.docx
touch ${root_dir}/reports/quarterly_reports/q1_summary.xlsx

# Templates
touch ${root_dir}/templates/product_description_templates/default_desc.txt
touch ${root_dir}/templates/sales_report_templates/sales_template.xlsx
touch ${root_dir}/templates/review_templates/review_format.md

# Prompt for script:
# Copy the 2024 product images for product B to a new folder named 'backup'

mkdir -p $root_dir/backup/
cp $root_dir/products/product_B/2024/product_images/image_b1.png $root_dir/backup/

git config --global user.email "test@test.com"
git config --global user.name "Test Test"
git -C "$root_dir" init
git -C "$root_dir" add -A
git -C "$root_dir" commit -m "initial commit"

