#!/bin/bash

root_dir=$1


mkdir -p $root_dir/01_Field_Work/01_Site_Reports
mkdir -p $root_dir/01_Field_Work/02_Maps
mkdir -p $root_dir/01_Field_Work/03_Sample_Data
mkdir -p $root_dir/02_Lab_Analysis/01_Rock_Analysis
mkdir -p $root_dir/02_Lab_Analysis/02_Soil_Analysis
mkdir -p $root_dir/02_Lab_Analysis/03_Data_Sheets
mkdir -p $root_dir/03_Research/01_Literature_Review
mkdir -p $root_dir/03_Research/02_Research_Proposal
mkdir -p $root_dir/03_Research/03_Research_Data
mkdir -p $root_dir/04_Presentations/01_Conference_Presentations
mkdir -p $root_dir/04_Presentations/02_Meeting_Presentations
mkdir -p $root_dir/05_Publications/01_Journal_Articles
mkdir -p $root_dir/05_Publications/02_Book_Chapters
mkdir -p $root_dir/06_Archive/01_Old_Reports
mkdir -p $root_dir/06_Archive/02_Old_Analyses
mkdir -p $root_dir/06_Archive/03_Old_Data

touch $root_dir/01_Field_Work/01_Site_Reports/site_report_1.pdf
touch $root_dir/01_Field_Work/01_Site_Reports/site_report_2.pdf
touch $root_dir/01_Field_Work/02_Maps/topographic_map_1.jpg
touch $root_dir/01_Field_Work/02_Maps/geological_map_1.jpg
touch $root_dir/01_Field_Work/03_Sample_Data/rock_sample_1.csv
touch $root_dir/01_Field_Work/03_Sample_Data/soil_sample_1.csv
touch $root_dir/02_Lab_Analysis/01_Rock_Analysis/rock_analysis_1.pdf
touch $root_dir/02_Lab_Analysis/01_Rock_Analysis/rock_analysis_2.pdf
touch $root_dir/02_Lab_Analysis/02_Soil_Analysis/soil_analysis_1.pdf
touch $root_dir/02_Lab_Analysis/02_Soil_Analysis/soil_analysis_2.pdf
touch $root_dir/02_Lab_Analysis/03_Data_Sheets/rock_data_sheet_1.xlsx
touch $root_dir/02_Lab_Analysis/03_Data_Sheets/soil_data_sheet_1.xlsx
touch $root_dir/03_Research/01_Literature_Review/paper_1.pdf
touch $root_dir/03_Research/01_Literature_Review/paper_2.pdf
touch $root_dir/03_Research/02_Research_Proposal/research_proposal.pdf
touch $root_dir/03_Research/03_Research_Data/research_data_1.csv
touch $root_dir/03_Research/03_Research_Data/research_data_2.csv
touch $root_dir/04_Presentations/01_Conference_Presentations/conference_presentation_1.ppt
touch $root_dir/04_Presentations/01_Conference_Presentations/conference_presentation_2.ppt
touch $root_dir/04_Presentations/02_Meeting_Presentations/meeting_presentation_1.ppt
touch $root_dir/04_Presentations/02_Meeting_Presentations/meeting_presentation_2.ppt
touch $root_dir/05_Publications/01_Journal_Articles/journal_article_1.pdf
touch $root_dir/05_Publications/01_Journal_Articles/journal_article_2.pdf
touch $root_dir/05_Publications/02_Book_Chapters/book_chapter_1.pdf
touch $root_dir/05_Publications/02_Book_Chapters/book_chapter_2.pdf
touch $root_dir/06_Archive/01_Old_Reports/old_site_report_1.pdf
touch $root_dir/06_Archive/01_Old_Reports/old_site_report_2.pdf
touch $root_dir/06_Archive/02_Old_Analyses/old_rock_analysis_1.pdf
touch $root_dir/06_Archive/02_Old_Analyses/old_soil_analysis_1.pdf
touch $root_dir/06_Archive/03_Old_Data/old_research_data_1.csv
touch $root_dir/06_Archive/03_Old_Data/old_research_data_2.csv

# Prompt for script:
# Copy the old data files to the Sample Data folder

cp -r "$root_dir/06_Archive/03_Old_Data/." "$root_dir/01_Field_Work/03_Sample_Data/"

git config --global user.email "test@test.com"
git config --global user.name "Test Test"
git -C "$root_dir" init
git -C "$root_dir" add -A
git -C "$root_dir" commit -m "initial commit"

