#!/bin/bash

root_dir=$1

# Patient Records
mkdir -p ${root_dir}/01_Patient_Records/01_Patient_A/2021/Consultation_Notes
mkdir -p ${root_dir}/01_Patient_Records/01_Patient_A/2021/Lab_Results
mkdir -p ${root_dir}/01_Patient_Records/01_Patient_A/2021/Prescriptions
mkdir -p ${root_dir}/01_Patient_Records/01_Patient_A/2021/X_Rays
mkdir -p ${root_dir}/01_Patient_Records/01_Patient_A/2022/Consultation_Notes
mkdir -p ${root_dir}/01_Patient_Records/01_Patient_A/2022/Lab_Results
mkdir -p ${root_dir}/01_Patient_Records/01_Patient_A/2022/Prescriptions
mkdir -p ${root_dir}/01_Patient_Records/01_Patient_A/2022/X_Rays
mkdir -p ${root_dir}/01_Patient_Records/02_Patient_B/2021/Consultation_Notes
mkdir -p ${root_dir}/01_Patient_Records/02_Patient_B/2021/Lab_Results
mkdir -p ${root_dir}/01_Patient_Records/02_Patient_B/2021/Prescriptions
mkdir -p ${root_dir}/01_Patient_Records/02_Patient_B/2021/X_Rays
mkdir -p ${root_dir}/01_Patient_Records/02_Patient_B/2022/Consultation_Notes
mkdir -p ${root_dir}/01_Patient_Records/02_Patient_B/2022/Lab_Results
mkdir -p ${root_dir}/01_Patient_Records/02_Patient_B/2022/Prescriptions
mkdir -p ${root_dir}/01_Patient_Records/02_Patient_B/2022/X_Rays

# Medical Research
mkdir -p ${root_dir}/02_Medical_Research/01_Research_Papers
mkdir -p ${root_dir}/02_Medical_Research/02_Research_Data

# Clinical Guidelines
mkdir -p ${root_dir}/03_Clinical_Guidelines/01_Disease_Management
mkdir -p ${root_dir}/03_Clinical_Guidelines/02_Surgical_Procedures

# Administrative
mkdir -p ${root_dir}/04_Administrative/01_Staff_Rosters
mkdir -p ${root_dir}/04_Administrative/02_Meeting_Minutes
mkdir -p ${root_dir}/04_Administrative/03_Policies_and_Procedures

# Create files
for dir in $(find ${root_dir}/ -type d); do
  touch ${dir}/dummy_file
done


# Prompt for script:
# Move the 2021 staff roster to an Archive folder

mkdir -p "$root_dir/04_Administrative/Archive"
mv "$root_dir/04_Administrative/01_Staff_Rosters/staff_roster_2021.xlsx" "$root_dir/04_Administrative/Archive/"

git config --global user.email "test@test.com"
git config --global user.name "Test Test"
git -C "$root_dir" init
git -C "$root_dir" add -A
git -C "$root_dir" commit -m "initial commit"

