#!/bin/bash

root_dir=$1


mkdir -p $root_dir/{01_Research/{01_Papers,02_Books,03_Articles},02_Data/{01_Corpora,02_Annotations,03_Transcriptions},03_Code/{01_Scripts,02_Libraries,03_Tests},04_Output/{01_Results,02_Visualizations,03_Reports},05_Documents/{01_Proposals,02_Presentations,03_Meeting_Notes}}

touch $root_dir/01_Research/01_Papers/{paper1,paper2}.pdf

touch $root_dir/01_Research/02_Books/{book1,book2}.pdf

touch $root_dir/01_Research/03_Articles/{article1,article2}.pdf

touch $root_dir/02_Data/01_Corpora/{corpus1,corpus2}.txt

touch $root_dir/02_Data/02_Annotations/{annotation1,annotation2}.csv

touch $root_dir/02_Data/03_Transcriptions/{transcription1,transcription2}.txt

touch $root_dir/03_Code/01_Scripts/{script1,script2}.py

touch $root_dir/03_Code/02_Libraries/{library1,library2}.py

touch $root_dir/03_Code/03_Tests/{test1,test2}.py

touch $root_dir/04_Output/01_Results/{result1,result2}.csv

touch $root_dir/04_Output/02_Visualizations/{visualization1,visualization2}.png

touch $root_dir/04_Output/03_Reports/{report1,report2}.pdf

touch $root_dir/05_Documents/01_Proposals/{proposal1,proposal2}.docx

touch $root_dir/05_Documents/02_Presentations/{presentation1,presentation2}.pptx

touch $root_dir/05_Documents/03_Meeting_Notes/{meeting1,meeting2}.txt

# Prompt for script:
# Delete the second test from the Code folder

rm "$root_dir/03_Code/03_Tests/test2.py"

git config --global user.email "test@test.com"
git config --global user.name "Test Test"
git -C "$root_dir" init
git -C "$root_dir" add -A
git -C "$root_dir" commit -m "initial commit"

