#!/bin/sh

# Define the root directory for the world tour logistics
ROOT_DIR=$1

# Create the root directory
mkdir -p "$ROOT_DIR"

# Create the subdirectories and files
mkdir -p "$ROOT_DIR/Tour_Overview"
touch "$ROOT_DIR/Tour_Overview/Tour_Schedule.docx"
touch "$ROOT_DIR/Tour_Overview/Budget.xlsx"
touch "$ROOT_DIR/Tour_Overview/Contact_List.xlsx"
touch "$ROOT_DIR/Tour_Overview/Logistics_Plan.docx"

# Create Venues structure
for i in 1 2 3 4 5; do # Adjust the number for more venues
    VENUE_DIR="$ROOT_DIR/Venues/Venue_${i}"
    mkdir -p "$VENUE_DIR/Contracts"
    touch "$VENUE_DIR/Contracts/Venue_${i}_Contract.pdf"
    mkdir -p "$VENUE_DIR/Layouts"
    touch "$VENUE_DIR/Layouts/Stage_Layout.pdf"
    touch "$VENUE_DIR/Layouts/Seating_Chart.pdf"
    touch "$VENUE_DIR/Technical_Specs.docx"
    touch "$VENUE_DIR/Contact_Info.docx"
done

# Create Transportation structure
mkdir -p "$ROOT_DIR/Transportation/Vehicle_Contracts"
touch "$ROOT_DIR/Transportation/Travel_Arrangements.docx"
touch "$ROOT_DIR/Transportation/Vehicle_Contracts/Bus_Contract.pdf"
touch "$ROOT_DIR/Transportation/Vehicle_Contracts/Truck_Contract.pdf"
touch "$ROOT_DIR/Transportation/Vehicle_Contracts/Equipment_Van_Contract.pdf"
mkdir -p "$ROOT_DIR/Transportation/Schedules"
touch "$ROOT_DIR/Transportation/Schedules/Departure_Schedule.xlsx"
touch "$ROOT_DIR/Transportation/Schedules/Arrival_Schedule.xlsx"
mkdir -p "$ROOT_DIR/Transportation/Maps/Venue_Maps"
touch "$ROOT_DIR/Transportation/Maps/Route_Map.pdf"
touch "$ROOT_DIR/Transportation/Maps/Venue_Maps/Venue_1_Map.pdf"
touch "$ROOT_DIR/Transportation/Maps/Venue_Maps/Venue_2_Map.pdf"
touch "$ROOT_DIR/Transportation/Maps/Venue_Maps/Venue_N_Map.pdf"

# Create Accommodations structure
mkdir -p "$ROOT_DIR/Accommodations/Hotel_Bookings"
touch "$ROOT_DIR/Accommodations/Hotel_Bookings/Hotel_Venue_1_Confirmation.pdf"
touch "$ROOT_DIR/Accommodations/Hotel_Bookings/Hotel_Venue_2_Confirmation.pdf"
touch "$ROOT_DIR/Accommodations/Hotel_Bookings/Hotel_Venue_N_Confirmation.pdf"
touch "$ROOT_DIR/Accommodations/Rooming_List.xlsx"
touch "$ROOT_DIR/Accommodations/Check_In_Check_Out_Schedule.xlsx"

# Create Equipment structure
mkdir -p "$ROOT_DIR/Equipment/Rental_Agreements"
touch "$ROOT_DIR/Equipment/Inventory_List.xlsx"
touch "$ROOT_DIR/Equipment/Rental_Agreements/Sound_Equipment_Contract.pdf"
touch "$ROOT_DIR/Equipment/Rental_Agreements/Lighting_Equipment_Contract.pdf"
touch "$ROOT_DIR/Equipment/Rental_Agreements/Staging_Equipment_Contract.pdf"
touch "$ROOT_DIR/Equipment/Technical_Requirements.docx"

# Create Staffing structure
mkdir -p "$ROOT_DIR/Staffing/Scheduling"
touch "$ROOT_DIR/Staffing/Crew_List.xlsx"
touch "$ROOT_DIR/Staffing/Roles_and_Responsibilities.docx"
touch "$ROOT_DIR/Staffing/Contact_Information.xlsx"
touch "$ROOT_DIR/Staffing/Scheduling/Crew_Schedule.xlsx"
touch "$ROOT_DIR/Staffing/Scheduling/Shift_Rotation.docx"

# Create Post_Tour structure
mkdir -p "$ROOT_DIR/Post_Tour/Feedback"
touch "$ROOT_DIR/Post_Tour/Debrief_Report.docx"
touch "$ROOT_DIR/Post_Tour/Financial_Report.xlsx"
touch "$ROOT_DIR/Post_Tour/Lessons_Learned.docx"
touch "$ROOT_DIR/Post_Tour/Feedback/Venue_Feedback.xlsx"
touch "$ROOT_DIR/Post_Tour/Feedback/Crew_Feedback.xlsx"

#######################################################################################################################
# Have venue contacts folder with all the contacts for each venue.
#######################################################################################################################

mkdir -p "$ROOT_DIR/Venue Contacts"
cp "$ROOT_DIR/Venues/Venue_1/Contacts_Info.docx" "$ROOT_DIR/Technical Specs/Contacts_Info_Venue_1.docx"
cp "$ROOT_DIR/Venues/Venue_2/Contacts_Info.docx" "$ROOT_DIR/Technical Specs/Contacts_Info_Venue_2.docx"
cp "$ROOT_DIR/Venues/Venue_3/Contacts_Info.docx" "$ROOT_DIR/Technical Specs/Contacts_Info_Venue_3.docx"
cp "$ROOT_DIR/Venues/Venue_4/Contacts_Info.docx" "$ROOT_DIR/Technical Specs/Contacts_Info_Venue_4.docx"
cp "$ROOT_DIR/Venues/Venue_5/Contacts_Info.docx" "$ROOT_DIR/Technical Specs/Contacts_Info_Venue_5.docx"


git config --global user.email "test@test.com"
git config --global user.name "Test Test"
git -C "$ROOT_DIR" init
git -C "$ROOT_DIR" add -A
git -C "$ROOT_DIR" commit -m "initial commit"
