#!/bin/bash

root_dir=$1


mkdir -p $root_dir/01_Strategy/01_Market_Research
mkdir -p $root_dir/01_Strategy/02_Content_Strategy
mkdir -p $root_dir/01_Strategy/03_Social_Media_Strategy
mkdir -p $root_dir/02_Creation/01_Graphics
mkdir -p $root_dir/02_Creation/02_Videos
mkdir -p $root_dir/02_Creation/03_Copywriting
mkdir -p $root_dir/03_Analytics/01_Performance_Reports
mkdir -p $root_dir/03_Analytics/02_Audience_Insights
mkdir -p $root_dir/04_Campaigns/01_Paid_Advertising/facebook_ads
mkdir -p $root_dir/04_Campaigns/01_Paid_Advertising/google_ads
mkdir -p $root_dir/04_Campaigns/02_Organic_Promotion/influencer_partnerships
mkdir -p $root_dir/04_Campaigns/02_Organic_Promotion/social_media_contests
mkdir -p $root_dir/05_Assets/01_Branding
mkdir -p $root_dir/05_Assets/02_Stock_Images

touch $root_dir/01_Strategy/01_Market_Research/competitor_analysis.pdf
touch $root_dir/01_Strategy/01_Market_Research/target_audience_analysis.pdf
touch $root_dir/01_Strategy/02_Content_Strategy/content_calendar.xlsx
touch $root_dir/01_Strategy/02_Content_Strategy/content_plan.docx
touch $root_dir/01_Strategy/03_Social_Media_Strategy/platform_strategy.pdf
touch $root_dir/01_Strategy/03_Social_Media_Strategy/posting_schedule.xlsx
touch $root_dir/02_Creation/01_Graphics/instagram_post.psd
touch $root_dir/02_Creation/01_Graphics/facebook_cover.jpg
touch $root_dir/02_Creation/02_Videos/youtube_video.mp4
touch $root_dir/02_Creation/02_Videos/instagram_story.mp4
touch $root_dir/02_Creation/03_Copywriting/blog_post.docx
touch $root_dir/02_Creation/03_Copywriting/social_media_captions.docx
touch $root_dir/03_Analytics/01_Performance_Reports/monthly_report.pdf
touch $root_dir/03_Analytics/01_Performance_Reports/annual_report.pdf
touch $root_dir/03_Analytics/02_Audience_Insights/audience_demographics.pdf
touch $root_dir/03_Analytics/02_Audience_Insights/audience_interests.pdf
touch $root_dir/04_Campaigns/01_Paid_Advertising/facebook_ads/ad_copy.docx
touch $root_dir/04_Campaigns/01_Paid_Advertising/facebook_ads/ad_graphics.psd
touch $root_dir/04_Campaigns/01_Paid_Advertising/google_ads/ad_copy.docx
touch $root_dir/04_Campaigns/01_Paid_Advertising/google_ads/ad_keywords.xlsx
touch $root_dir/04_Campaigns/02_Organic_Promotion/influencer_partnerships/influencer_contract.pdf
touch $root_dir/04_Campaigns/02_Organic_Promotion/influencer_partnerships/influencer_brief.docx
touch $root_dir/04_Campaigns/02_Organic_Promotion/social_media_contests/contest_rules.pdf
touch $root_dir/04_Campaigns/02_Organic_Promotion/social_media_contests/contest_graphics.psd
touch $root_dir/05_Assets/01_Branding/logo.ai
touch $root_dir/05_Assets/01_Branding/brand_guidelines.pdf
touch $root_dir/05_Assets/02_Stock_Images/image1.jpg
touch $root_dir/05_Assets/02_Stock_Images/image2.jpg


# Prompt for script:
# Create a backup of the "annual_report.pdf" file in the "Backup" folder

mkdir -p "$root_dir/Backup" && cp "$root_dir/03_Analytics/01_Performance_Reports/annual_report.pdf" "$root_dir/Backup/"

git config --global user.email "test@test.com"
git config --global user.name "Test Test"
git -C "$root_dir" init
git -C "$root_dir" add -A
git -C "$root_dir" commit -m "initial commit"

