#!/bin/bash

root_dir=$1

mkdir -p ${root_dir}/01_Research/Autonomous_Vehicles
mkdir -p ${root_dir}/01_Research/Traffic_Management
mkdir -p ${root_dir}/02_Projects/Autonomous_Vehicles/Project_A/Design
mkdir -p ${root_dir}/02_Projects/Autonomous_Vehicles/Project_A/Implementation
mkdir -p ${root_dir}/02_Projects/Autonomous_Vehicles/Project_A/Reports
mkdir -p ${root_dir}/02_Projects/Autonomous_Vehicles/Project_B/Design
mkdir -p ${root_dir}/02_Projects/Autonomous_Vehicles/Project_B/Implementation
mkdir -p ${root_dir}/02_Projects/Autonomous_Vehicles/Project_B/Reports
mkdir -p ${root_dir}/02_Projects/Traffic_Management/Project_A/Design
mkdir -p ${root_dir}/02_Projects/Traffic_Management/Project_A/Implementation
mkdir -p ${root_dir}/02_Projects/Traffic_Management/Project_A/Reports
mkdir -p ${root_dir}/02_Projects/Traffic_Management/Project_B/Design
mkdir -p ${root_dir}/02_Projects/Traffic_Management/Project_B/Implementation
mkdir -p ${root_dir}/02_Projects/Traffic_Management/Project_B/Reports
mkdir -p ${root_dir}/03_Documents/Meeting_Notes
mkdir -p ${root_dir}/03_Documents/Proposals
mkdir -p ${root_dir}/03_Documents/Specifications
mkdir -p ${root_dir}/04_Resources/Autonomous_Vehicles
mkdir -p ${root_dir}/04_Resources/Traffic_Management

touch ${root_dir}/01_Research/Autonomous_Vehicles/AV_Research_Paper_1.pdf
touch ${root_dir}/01_Research/Autonomous_Vehicles/AV_Research_Paper_2.pdf
touch ${root_dir}/01_Research/Traffic_Management/TM_Research_Paper_1.pdf
touch ${root_dir}/01_Research/Traffic_Management/TM_Research_Paper_2.pdf
touch ${root_dir}/02_Projects/Autonomous_Vehicles/Project_A/Design/AV_Design_Document.docx
touch ${root_dir}/02_Projects/Autonomous_Vehicles/Project_A/Design/AV_Design_Sketch.jpg
touch ${root_dir}/02_Projects/Autonomous_Vehicles/Project_A/Implementation/AV_Code.zip
touch ${root_dir}/02_Projects/Autonomous_Vehicles/Project_A/Implementation/AV_Test_Results.xlsx
touch ${root_dir}/02_Projects/Autonomous_Vehicles/Project_A/Reports/AV_Monthly_Report.pdf
touch ${root_dir}/02_Projects/Autonomous_Vehicles/Project_A/Reports/AV_Final_Report.pdf
touch ${root_dir}/02_Projects/Autonomous_Vehicles/Project_B/Design/AV_Design_Document.docx
touch ${root_dir}/02_Projects/Autonomous_Vehicles/Project_B/Design/AV_Design_Sketch.jpg
touch ${root_dir}/02_Projects/Autonomous_Vehicles/Project_B/Implementation/AV_Code.zip
touch ${root_dir}/02_Projects/Autonomous_Vehicles/Project_B/Implementation/AV_Test_Results.xlsx
touch ${root_dir}/02_Projects/Autonomous_Vehicles/Project_B/Reports/AV_Monthly_Report.pdf
touch ${root_dir}/02_Projects/Autonomous_Vehicles/Project_B/Reports/AV_Final_Report.pdf
touch ${root_dir}/02_Projects/Traffic_Management/Project_A/Design/TM_Design_Document.docx
touch ${root_dir}/02_Projects/Traffic_Management/Project_A/Design/TM_Design_Sketch.jpg
touch ${root_dir}/02_Projects/Traffic_Management/Project_A/Implementation/TM_Code.zip
touch ${root_dir}/02_Projects/Traffic_Management/Project_A/Implementation/TM_Test_Results.xlsx
touch ${root_dir}/02_Projects/Traffic_Management/Project_A/Reports/TM_Monthly_Report.pdf
touch ${root_dir}/02_Projects/Traffic_Management/Project_A/Reports/TM_Final_Report.pdf
touch ${root_dir}/02_Projects/Traffic_Management/Project_B/Design/TM_Design_Document.docx
touch ${root_dir}/02_Projects/Traffic_Management/Project_B/Design/TM_Design_Sketch.jpg
touch ${root_dir}/02_Projects/Traffic_Management/Project_B/Implementation/TM_Code.zip
touch ${root_dir}/02_Projects/Traffic_Management/Project_B/Implementation/TM_Test_Results.xlsx
touch ${root_dir}/02_Projects/Traffic_Management/Project_B/Reports/TM_Monthly_Report.pdf
touch ${root_dir}/02_Projects/Traffic_Management/Project_B/Reports/TM_Final_Report.pdf
touch ${root_dir}/03_Documents/Meeting_Notes/Meeting_Notes_1.docx
touch ${root_dir}/03_Documents/Meeting_Notes/Meeting_Notes_2.docx
touch ${root_dir}/03_Documents/Proposals/Proposal_1.docx
touch ${root_dir}/03_Documents/Proposals/Proposal_2.docx
touch ${root_dir}/03_Documents/Specifications/Specification_1.docx
touch ${root_dir}/03_Documents/Specifications/Specification_2.docx
touch ${root_dir}/04_Resources/Autonomous_Vehicles/AV_Resource_1.pdf
touch ${root_dir}/04_Resources/Autonomous_Vehicles/AV_Resource_2.pdf
touch ${root_dir}/04_Resources/Traffic_Management/TM_Resource_1.pdf
touch ${root_dir}/04_Resources/Traffic_Management/TM_Resource_2.pdf


# End of setup

# Prompt: Create a new folder named 'Archived_Meeting_Notes' under 03_Documents and move all Meeting_Notes into it

mkdir -p ${root_dir}/03_Documents/Archived_Meeting_Notes
mv ${root_dir}/03_Documents/Meeting_Notes/Meeting_Notes_1.docx ${root_dir}/03_Documents/Archived_Meeting_Notes/
mv ${root_dir}/03_Documents/Meeting_Notes/Meeting_Notes_2.docx ${root_dir}/03_Documents/Archived_Meeting_Notes/

git config --global user.email "test@test.com"
git config --global user.name "Test Test"
git -C "$root_dir" init
git -C "$root_dir" add -A
git -C "$root_dir" commit -m "initial commit"
