# Firstly we load the csv:
# Secondly we load the json files

from collections import Counter
import csv


output_file = 'bl_gray_lc.csv'


total_toknes = 0
reader = None

data = {}

with open(output_file, 'r') as csvfile:
    reader = csv.DictReader(csvfile)
    rows = [row for row in reader]
    
errors = []

for row in rows:
    if row['Is bug'] == 'n':
        continue
    if row['LLMScore'] == '' or int(row['LLMScore']) > 5:
        continue
    
    errors.append(row['tool'] + ';' + row['type'])

ce = Counter(errors)
count_of_ones = sum(1 for count in ce.values() if count == 1)
count_of_more_than_ones = sum(1 for count in ce.values() if count == 2)
# Sum all counts:
counts = sum(ce.values())
print("Count of errors appearing once:", count_of_ones)
print("Count of errors that appear twice:", count_of_more_than_ones)
print(len(errors))
