# Firstly we load the csv:
# Secondly we load the json files

import csv
import json
import os


output_file = 'baseline_lang.csv'

basedir = "./baseline/corr_white_langc/"

total_toknes = 0
reader = None

data = {}

with open(output_file, newline='') as csvfile:
    reader = csv.DictReader(csvfile)
    rows = [row for row in reader]
    
for file in os.listdir(basedir):
    with open(basedir + file, 'r') as f:
        tinfo = json.load(f)
        if len(tinfo) == 0:
            continue
        name = file.split('res_bl_wh_')[1].split('_over_budget.json')[0]
        print(name, len(tinfo))
        data[name] = tinfo

# So now we need the tokens:
for row in rows:
    if row['tool'] == '':
        continue
    # Find the row in the data:
    tool = row['tool']
    all_data = data[tool]
    indx = 0
    for item in all_data:
        if row['Prompt'] in item['prompt']:
            break
        indx += 1
    if indx >= len(all_data):
        print("Error: Index out of range")
        continue
    tokens = all_data[indx]['llm_agent_out_reason']
    tokens = int(tokens.split(', ')[1])
    if indx != 0:
        tokens_prev = all_data[indx-1]['llm_agent_out_reason']
        tokens_prev = int(tokens_prev.split(', ')[1])
        total_toknes += tokens - tokens_prev
    else:
        total_toknes += tokens

print(total_toknes)
    