# Firstly we load the csv:
# Secondly we load the json files

import csv
import json
import os


output_file = 'filtered_composio_labels.csv'

basedir = "./toolfuzz/results/composio_budget_gpt4o_corr/"

total_toknes = 0
reader = None

data = {}

with open(output_file, newline='') as csvfile:
    reader = csv.DictReader(csvfile)
    rows = [row for row in reader]
    
for file in os.listdir(basedir):
    with open(basedir + file, 'r') as f:
        tinfo = json.load(f)
        if len(tinfo) == 0:
            continue
        print(file, len(tinfo))
        data[tinfo[0]['tool']] = tinfo

# So now we need the tokens:
for row in rows:
    if row['tool'] == '':
        continue
    # Find the row in the data:
    tool = row['tool']
    all_data = data[tool]
    indx = 0
    for item in all_data:
        if row['Prompt'] in item['template_prompts']:
            break
        indx += 1

    if indx != 0:
        total_toknes += all_data[indx]['prompt_tokens'] - all_data[indx-1]['prompt_tokens']
    else:
        total_toknes += all_data[indx]['prompt_tokens']

print(total_toknes)
    