from collections import Counter
import json
import os
import csv


BASE_DIR = "baseline/fail_grey_comp"

result_csv = f"{BASE_DIR}.csv"

tool_calls = 0
total_counts_of_one = 0
total_counts_of_more_than_ones = 0
total_counts = 0
prompts = 0

# Write 3 columns in the csv file:
with open(result_csv, "w") as csvfile:
    writer = csv.writer(csvfile, quoting=csv.QUOTE_ALL, escapechar='\\')
    writer.writerow(["Tool", "Count", "Errors"])

    for file in os.listdir(BASE_DIR):
        if not file.endswith(".json"):
            continue
        with open(f"{BASE_DIR}/{file}") as f:
            data = json.load(f)
        # Now get just the errors:
        # filter the non calls:
        data = [d for d in data if d["invocation_params"] != "" or d["invocation_params"] is not None or d["invocation_params"] != "No tool arguments found"]
        prompts += data[-1]['prompt_tokens']
        tool_calls += len(data)
        data = [d for d in data if d["successful_trigger"]]
        # Now get the errors:
        errors = [d["exception"] for d in data if d["exception"] != ""]
        ce = Counter(t['exception'][:15] for t in data if t['exception'] if t['exception'].startswith('<') or t['exception'][0].isupper())
        print(ce)
        count_of_ones = sum(1 for count in ce.values() if count == 1)
        count_of_more_than_ones = sum(1 for count in ce.values() if count == 2)
        total_counts_of_one += count_of_ones
        total_counts_of_more_than_ones += count_of_more_than_ones
        total_counts += sum(ce.values())

        errors = set(errors)
        tool = file.split("_")[3:-2]

        tool = "_".join(tool)
        # Write to the csv
        writer.writerow([tool, len(errors), ";".join(errors)])

# So Now i need to collect the number of tool calls and put them in
print(f"Total tool calls: {tool_calls}")
print(f"Total tokens: {prompts}")
print(f"Total counts of one: {total_counts_of_one}")
print(f"Total counts of more than one: {total_counts_of_more_than_ones}")
print(f"Total counts: {total_counts}")