tree_computer_science = """
.
├── 01_Projects
│     ├── 01_ProjectA
│     │     ├── 01_Code
│     │     │     ├── main.py
│     │     │     ├── tests
│     │     │     │     ├── test_main.py
│     │     │     │     └── test_utils.py
│     │     │     └── utils.py
│     │     ├── 02_Documentation
│     │     │     └── README.md
│     │     └── 03_Data
│     │         ├── input
│     │         │     └── data.csv
│     │         └── output
│     │             └── results.csv
│     └── 02_ProjectB
│         ├── 01_Code
│         │     ├── main.py
│         │     ├── tests
│         │     │     ├── test_main.py
│         │     │     └── test_utils.py
│         │     └── utils.py
│         ├── 02_Documentation
│         │     └── README.md
│         └── 03_Data
│             ├── input
│             │     └── data.csv
│             └── output
│                 └── results.csv
├── 02_Research
│     ├── 01_Papers
│     │     ├── paper1.pdf
│     │     └── paper2.pdf
│     └── 02_Notes
│         └── research_notes.txt
├── 03_Tools
│     ├── 01_Scripts
│     │     ├── data_cleaning.py
│     │     └── data_visualization.py
│     └── 02_Libraries
│         ├── library1
│         │     └── lib1.py
│         └── library2
│             └── lib2.py
└── 04_Tutorials
    ├── 01_Python
    │     ├── python_advanced.md
    │     └── python_basics.md
    └── 02_Machine_Learning
        ├── ml_advanced.md
        └── ml_basics.md
"""

tree_biotechnology = """
.
├── 01_Research
│     ├── 01_Literature_Review
│     │     ├── paper1.pdf
│     │     └── paper2.pdf
│     ├── 02_Experimental_Design
│     │     ├── experiment1.docx
│     │     └── experiment2.docx
│     └── 03_Data
│         ├── data1.csv
│         └── data2.csv
├── 02_Experiments
│     ├── 01_Setup
│     │     ├── setup1.docx
│     │     └── setup2.docx
│     ├── 02_Results
│     │     ├── result1.csv
│     │     └── result2.csv
│     └── 03_Analysis
│         ├── analysis1.xlsx
│         └── analysis2.xlsx
├── 03_Patents
│     ├── 01_Applications
│     │     ├── application1.pdf
│     │     └── application2.pdf
│     └── 02_Granted
│         ├── patent1.pdf
│         └── patent2.pdf
├── 04_Publications
│     ├── 01_Drafts
│     │     ├── draft1.docx
│     │     └── draft2.docx
│     └── 02_Published
│         ├── paper1.pdf
│         └── paper2.pdf
├── 05_Presentations
│     ├── 01_Conferences
│     │     ├── conference1.pptx
│     │     └── conference2.pptx
│     └── 02_Seminars
│         ├── seminar1.pptx
│         └── seminar2.pptx
└── 06_Grants
    ├── 01_Applications
    │     ├── application1.pdf
    │     └── application2.pdf
    └── 02_Awarded
        ├── grant1.pdf
        └── grant2.pdf

"""

tree_agriculture = """
.
├── 01_Field_Data
│     ├── 01_Soil_Samples
│     │     ├── soil_sample_001.csv
│     │     └── soil_sample_002.csv
│     ├── 02_Weather_Data
│     │     ├── weather_data_2023.csv
│     │     └── weather_data_2024.csv
│     └── 03_Crop_Yields
│         ├── crop_yield_2023.csv
│         └── crop_yield_2024.csv
├── 02_Precision_Farming_Tools
│     ├── 01_Drones
│     │     ├── drone_flight_data_001.csv
│     │     └── drone_flight_data_002.csv
│     ├── 02_Sensors
│     │     ├── sensor_data_001.csv
│     │     └── sensor_data_002.csv
│     └── 03_Satellite_Images
│         ├── satellite_image_001.jpg
│         └── satellite_image_002.jpg
├── 03_Analysis_Reports
│     ├── 01_Soil_Analysis
│     │     └── soil_analysis_2023.pdf
│     ├── 02_Weather_Analysis
│     │     └── weather_analysis_2023.pdf
│     └── 03_Crop_Yield_Analysis
│         └── crop_yield_analysis_2023.pdf
├── 04_Farming_Strategies
│     ├── 01_Irrigation
│     │     ├── irrigation_plan_2023.pdf
│     │     └── irrigation_plan_2024.pdf
│     ├── 02_Fertilization
│     │     ├── fertilization_plan_2023.pdf
│     │     └── fertilization_plan_2024.pdf
│     └── 03_Pest_Control
│         ├── pest_control_plan_2023.pdf
│         └── pest_control_plan_2024.pdf
├── 05_Archives
│     ├── 01_Old_Data
│     │     ├── old_crop_yields.zip
│     │     ├── old_soil_samples.zip
│     │     └── old_weather_data.zip
│     └── 02_Old_Reports
│         ├── old_crop_yield_analysis.zip
│         ├── old_soil_analysis.zip
│         └── old_weather_analysis.zip
└── 06_Templates
    ├── 01_Report_Templates
    │     ├── crop_yield_analysis_template.docx
    │     ├── soil_analysis_template.docx
    │     └── weather_analysis_template.docx
    └── 02_Strategy_Templates
        ├── fertilization_plan_template.docx
        ├── irrigation_plan_template.docx
        └── pest_control_plan_template.docx
"""

file_system_context = """
./file_context/Law_Student_Files
├── Academics
│   ├── Courses
│   │   ├── Semester_1
│   │   │   ├── Contract_Law
│   │   │   │   ├── Assignments
│   │   │   │   │   ├── assignment_1_draft.docx
│   │   │   │   │   └── assignment_1_final.pdf
│   │   │   │   ├── Lecture_Notes
│   │   │   │   │   ├── week_1_contract_law_notes.pdf
│   │   │   │   │   └── week_2_contract_law_notes.pdf
│   │   │   │   └── Readings
│   │   │   │       ├── case_study_smith_vs_jones.pdf
│   │   │   │       └── chapter1_contract_law.pdf
│   │   │   ├── Criminal_Law
│   │   │   │   ├── Assignments
│   │   │   │   │   ├── mock_trial_outline.docx
│   │   │   │   │   └── research_project_final.pdf
│   │   │   │   ├── Lecture_Notes
│   │   │   │   │   ├── week_1_criminal_law_notes.pdf
│   │   │   │   │   └── week_2_criminal_law_notes.pdf
│   │   │   │   └── Readings
│   │   │   │       ├── case_law_brief_r_v_white.pdf
│   │   │   │       └── chapter3_criminal_law.pdf
│   │   │   └── Legal_Writing
│   │   │       ├── Assignments
│   │   │       │   └── legal_memorandum_final.docx
│   │   │       ├── Lecture_Notes
│   │   │       │   └── citation_practices.pdf
│   │   │       └── Templates
│   │   │           ├── case_brief_template.docx
│   │   │           └── research_outline_template.docx
│   │   └── Semester_2
│   │       ├── Constitutional_Law
│   │       │   ├── Assignments
│   │       │   │   └── judicial_review_essay.docx
│   │       │   ├── Lecture_Notes
│   │       │   │   └── lecture_1_notes.pdf
│   │       │   └── Readings
│   │       │       └── constitutional_cases_summary.pdf
│   │       ├── Moot_Court
│   │       │   ├── Case_Files
│   │       │   │   ├── appellant_brief.pdf
│   │       │   │   └── respondent_brief.pdf
│   │       │   ├── Resources
│   │       │   │   └── oral_argument_tips.pdf
│   │       │   └── Videos
│   │       │       └── mock_court_session.mp4
│   │       └── Property_Law
│   │           ├── Assignments
│   │           │   └── land_ownership_case_study.docx
│   │           ├── Lecture_Notes
│   │           │   └── week_1_property_law_notes.pdf
│   │           └── Readings
│   │               └── property_law_key_readings.pdf
│   ├── Exams
│   │   ├── Past_Papers
│   │   │   ├── semester1_contract_law_exam.pdf
│   │   │   └── semester1_criminal_law_exam.pdf
│   │   ├── Practice_Questions
│   │   │   └── contract_law_practice_questions.docx
│   │   └── Study_Notes
│   │       ├── semester1_summary.docx
│   │       └── semester2_outline.pdf
│   ├── Research
│   │   ├── Projects
│   │   │   ├── research_project1
│   │   │   │   └── project_report.pdf
│   │   │   └── research_project2
│   │   │       └── presentation_slides.pptx
│   │   └── Thesis
│   │       ├── drafts
│   │       │   └── chapter1_draft.docx
│   │       ├── final
│   │       │   └── thesis_final.pdf
│   │       └── references
│   │           ├── case_law_citations.txt
│   │           └── mla_reference_list.docx
│   └── Resources
│       ├── Case_Laws
│       │   ├── commonwealth_vs_doe.pdf
│       │   └── johnson_vs_brown.pdf
│       ├── Ebooks
│       │   ├── fundamentals_of_legal_analysis.epub
│       │   └── introduction_to_law.pdf
│       └── Tools
│           ├── citation_guide.pdf
│           └── legal_writing_tips.docx
├── Personal
│   ├── Finances
│   │   ├── Expenses
│   │   └── Scholarships
│   ├── Health
│   │   ├── Meal_Plans
│   │   └── Workout_Plans
│   └── Leisure
│       ├── Books
│       │   ├── fiction
│       │   │   └── to_kill_a_mockingbird.epub
│       │   └── non_fiction
│       │       └── becoming_rbg.pdf
│       ├── Games
│       ├── Movies
│       │   ├── comedy
│       │   │   └── legally_blonde.mp4
│       │   └── legal_thrillers
│       │       └── a_few_good_men.mp4
│       └── Music
└── Templates
"""

ghub_context = """
Pull requests:
    PullRequest(title='Feature 1 done', body='PR for feature 1', head='feature_branch_1', base='main'),
    PullRequest(title='Feature 2 done', body='PR for feature 2', head='feature_branch_2', base='main'),
    PullRequest(title='Feature 3 done', body='PR for feature 3', head='feature_branch_3', base='main'),
    PullRequest(title='Feature 4 done', body='Dummy test feature 4', head='feature_branch_4', base='main'),
    PullRequest(title='Feature 5 done', body='Dummy test feature 5', head='feature_branch_5', base='main')

Issues:
    Issue(title='Java 11', body='Java 7 is very old version can you migrate the project to newer version'),
    Issue(title='Update dependencies', body='Update the dependencies to latest versions')

Branches:
    main
    feature_branch_1
    feature_branch_2
    feature_branch_3
    feature_branch_4
    feature_branch_5

main branch structure:
.
└── src
    └── main
        ├── java
        │   └── com
        │       └── example
        │           └── servlets
        │               ├── GoodbyeServlet.java
        │               └── HelloServlet.java
        └── webapp
            └── WEB-INF
                └── web.xml
"""

docker_env_context = f"""
Can you please generate prompts related to moving/copying/finding files related to the following environments:
{tree_computer_science}

{tree_biotechnology}

{tree_agriculture}
"""

python_source_code_context = """
./toolfuzz/agent_executors
├── __init__.py
├── __pycache__
│   ├── __init__.cpython-310.pyc
│   └── agent_executor.cpython-310.pyc
├── agent_executor.py
├── autogen
│   ├── __init__.py
│   ├── assistant_agent.py
│   └── routed_agent.py
├── crewai
│   ├── __init__.py
│   └── agent.py
├── langchain
│   ├── __init__.py
│   ├── __pycache__
│   │   ├── __init__.cpython-310.pyc
│   │   ├── react_new.cpython-310.pyc
│   │   └── react_old.cpython-310.pyc
│   ├── openai_function.py
│   ├── react_new.py
│   └── react_old.py
└── llama_index
    ├── __init__.py
    ├── coa_agent.py
    ├── function_calling_agent.py
    ├── lats_agent.py
    ├── llama_index_agent.py
    ├── openai_agent.py
    └── react_agent.py"""