from abc import abstractmethod, ABC


class LangChainToolLoader(ABC):
    @abstractmethod
    def get_tool(self): raise NotImplementedError()

    @abstractmethod
    def can_load(self, tool: str) -> bool: raise NotImplementedError()


class LangChainToolkitLoader(ABC):
    @abstractmethod
    def get_tools(self): raise NotImplementedError()

    @abstractmethod
    def can_load(self, name: str) -> bool: raise NotImplementedError()