import os
from argparse import ArgumentParser

def parse_args():
    parser = ArgumentParser(description="Rerun toolfuzz jobs")
    parser.add_argument("-d", type=str, required=True, help="Path to the result directory" )
    parser.add_argument("-f", type=str, required=True, help="The file with all the runs.")
    return parser.parse_args()


def get_left_runs():
    # Scan the directory for all the runs
    # Check if the run is finished
    with open(args.f, "r") as f:
        lines = f.readlines()
    lines = [line.strip() for line in lines]

    found_files = []
    for file in os.listdir(args.d):
        if file.endswith(".json") and file.startswith("res_bl_gr_"):
            name = file.split("_over_budget.json")[0]
            name = name.split("res_bl_gr_")[-1]
            found_files.append(name)
        elif file.endswith(".json") and file.startswith("res_f"):
            name = file.split("_over_budget.json")[0]
            name = file.split("_gpt-4o")[0]
            if "res_f_tool_calling_agent_timeout_" in name:
                name = name.split("res_f_tool_calling_agent_timeout_")[-1]
            else:
                name = name.split("res_f_tool_calling_agent_")[-1]
            found_files.append(name)
        elif file.endswith(".json") and file.startswith("res_f_"):
            name = file.split("_over_budget.json")[0]
            name = name.split("_gpt-4o")[0]
            name = name.split("res_f_")[-1]
            found_files.append(name)
    # Now get the files that are not in both lines and found_files
    left_files = []
    for line in lines:
        if line not in found_files:
            left_files.append(line)
    for line in left_files:
        print(line)

if __name__ == "__main__":
    args = parse_args()
    get_left_runs()