import os
from argparse import ArgumentParser
import shutil

def parse_args():
    parser = ArgumentParser(description="Rerun toolfuzz jobs")
    parser.add_argument("-d", type=str, required=True, help="Path to the result directory" )
    parser.add_argument("-f", type=str, required=True, help="The file with all the runs.")
    return parser.parse_args()

args = parse_args()

def split_files():
    with open(args.f, "r") as f:
        lines = f.readlines()
    lines = [line.strip() for line in lines]
    # Create directory named composio
    if not os.path.exists("composio"):
        os.makedirs(f"{args.d}/composio")
    for file in os.listdir(args.d):
        move_file = False
        for tool in lines:
            if tool in file:
                move_file = True
                break
        if move_file:
            shutil.move(f"{args.d}/{file}", f"{args.d}/composio/{file}")            

if __name__ == "__main__":
    split_files()