#!/bin/bash 

#export PYTHONNOUSERSITE=True

#SBATCH --nodes=1                   # Number of nodes to request
#SBATCH --cpus-per-task=32           # Number of CPUs per node to request
#SBATCH --gpus-per-node=0           # Number of GPUs per node to request  
#SBATCH --mem=120G                  # Maximum amount of memory this job will be given
#SBATCH --job-name="sens_run"    # A nice readable name of your job, to see it in the queue, instead of numbers
#SBATCH --output=sens_run.out     # Store the output console text to a file called jobName.<assigned job number>.out
#SBATCH --error=sens_run.err      # Store the error messages to a file called jobName.<assigned job number>.err

source /opt/conda/bin/activate ~/.conda/envs/advrob

python3 ~/ROB_BOX/sens_calc_pipeline.py cifar10 2 32 

exit 0