#!/bin/bash 

#export PYTHONNOUSERSITE=True

#SBATCH --nodes=1                   # Number of nodes to request
#SBATCH --cpus-per-task=32           # Number of CPUs per node to request
#SBATCH --gpus-per-node=4           # Number of GPUs per node to request  
#SBATCH --mem=120G                  # Maximum amount of memory this job will be given
#SBATCH --job-name="S2B"    # A nice readable name of your job, to see it in the queue, instead of numbers
#SBATCH --output=S2B.out     # Store the output console text to a file called jobName.<assigned job number>.out
#SBATCH --error=S2B.err      # Store the error messages to a file called jobName.<assigned job number>.err

source /opt/conda/bin/activate /home/<user>/.conda/envs/advrob

python3 /home/<user>/S2B/train-wa.py \
	--batch-size 2048 \
	--batch-size-validation 512 \
    \
    --data-dir "/home/<user>/DATA" \
    --log-dir "/home/<user>/S2B/LOG" \
    \
    --data "cifar10s" \
    --desc "S2B" \
    \
    --model "wrn-28-10-swish" \
    \
    --num-adv-epochs 1600 \
    --adv-eval-freq 3200 \
    \
    --beta 5.0 \
    \
    --lr 0.2 \
    --scheduler "cosinew" \
    \
    --attack "l2-pgd" \
    --attack-eps 0.5019607843137255 \
    --attack-step 0.12549019607843137 \
    --attack-iter 10 \
    \
    --unsup-fraction 0.8 \
    --aux-data-filename "/home/<user>/DATA/50m.npz" \
    \
    --seed 1337 \
    \
    --tau 0.995 \

exit 0