#!/bin/bash 

#export PYTHONNOUSERSITE=True

#SBATCH --nodes=1                   # Number of nodes to request
#SBATCH --cpus-per-task=32           # Number of CPUs per node to request
#SBATCH --gpus-per-node=4           # Number of GPUs per node to request  
#SBATCH --mem=120G                  # Maximum amount of memory this job will be given
#SBATCH --job-name="S3B_plus"    # A nice readable name of your job, to see it in the queue, instead of numbers
#SBATCH --output=S3B_plus.out     # Store the output console text to a file called jobName.<assigned job number>.out
#SBATCH --error=S3B_plus.err      # Store the error messages to a file called jobName.<assigned job number>.err

source /opt/conda/bin/activate /home/<user>/.conda/envs/advrob

python3 /home/<user>/S3B_plus/train-wa.py \
	--batch-size 2080 \
	--batch-size-validation 512 \
    \
    --data-dir "/home/<user>/DATA" \
    --log-dir "/home/<user>/S3B_plus/LOG" \
    \
    --data "cifar100s" \
    --desc "S3B_plus" \
    \
    --model "wrn-28-10-swish" \
    \
    --num-adv-epochs 2000 \
    --adv-eval-freq 4000 \
    \
    --beta 5.0 \
    \
    --lr 0.2 \
    --scheduler "cosinew" \
    \
    --attack "linf-pgd" \
    --attack-eps 0.03137254901960784 \
    --attack-step 0.00784313725490196 \
    --attack-iter 10 \
    \
    --unsup-fraction 0.8 \
    --aux-data-filename "/home/<user>/DATA/cifar100/50m.npz" \
    \
    --seed 1337 \
    \
    --tau 0.995 \

exit 0