#!/bin/bash 

#export PYTHONNOUSERSITE=True

#SBATCH --nodes=1                   # Number of nodes to request
#SBATCH --cpus-per-task=8           # Number of CPUs per node to request
#SBATCH --gpus-per-node=1           # Number of GPUs per node to request  
#SBATCH --mem=20G                  # Maximum amount of memory this job will be given
#SBATCH --job-name="S3B_plus_eval_last"    # A nice readable name of your job, to see it in the queue, instead of numbers
#SBATCH --output=S3B_plus_eval_last.out     # Store the output console text to a file called jobName.<assigned job number>.out
#SBATCH --error=S3B_plus_eval_last.err      # Store the error messages to a file called jobName.<assigned job number>.err

source /opt/conda/bin/activate /home/<user>/.conda/envs/advrob

python3 /home/<user>/S3B_plus/eval-last-aa.py \
    --data-dir '/home/<user>/DATA' \
    --log-dir '/home/<user>/S3B_plus/LOG' \
    \
    --desc 'S3B_plus' \
    --num-samples 10000 \
    \
    --seed 1337 

exit 0
