%% visualize results of PQRST complexes data applying Prior Model 2
addpath('./Functions')
resultfile = "./result/Data_ECG_PriorModel2MCMC_main_BSpline_random_BSpline_basisnum_12_6_nG_5.mat";
load(resultfile);
% individual function for phase function visualization
subject_idx = 1;
% uniform subsample for visualizing
visN =1000;
activeIndeces = round(linspace(burn,iterations,visN));
cols = get(0, 'DefaultAxesColorOrder');
numrep = ceil(N/length(cols));
cols = repmat(cols,numrep,1);
% data (Figure 1, panel d)
for ii = 1:N
    plot(t,qt{ii},'color',cols(ii,:),'LineWidth',2);
    hold on
end
hold off
set(gca,'fontsize',55)
set(gcf,'position',[10,10,800,800])
pbaspect([1 1 1])
saveas(gcf,sprintf("./figure/%s_data.png",datatype))

% posterior samples and posterior mean for fixed effect (panel a)
first = true;
for ii = burn+1:iterations
    qmu_s = U1*a_samples(ii,:)';
    gam_bar = mean(gamma_samples(ii,:,:),3);
    gt_bar = interp1(tG,gam_bar,t,'linear');
    gt_bar(end) = 1;
    if first
        post_mean_0 = qmu_s;
        post_mean_gam = gt_bar;
        first = false;
    else
        post_mean_0 = post_mean_0 + qmu_s;
        post_mean_gam = post_mean_gam + gt_bar;
    end
end
post_mean_0 = post_mean_0/(iterations-burn);
post_mean_gam = post_mean_gam/(iterations-burn);
post_mean_warped = qComposeGamma(post_mean_0,t,post_mean_gam);
first = true;
for ii = activeIndeces
    qmu_s = U1*a_samples(ii,:)';
    qmu_s_warped = qComposeGamma(qmu_s,t,post_mean_gam);
    plot1 = plot(t,qmu_s_warped,'color',[cols(1,:),0.1]);
    hold on
    if first
        plot_temp = plot(NaN,NaN,'color',cols(1,:),'LineWidth', 3);
        first = false;
    end
end

plot2 = plot(t,post_mean_warped,'color','red','linewidth',8);
hold off
legend([plot_temp, plot2],...
    {'Centered Post. Samp.','Centered Post. Mean'},...
    'Location','best')
ylim([-2 5])
set(gca,'fontsize',55)
set(gcf,'position',[10,10,800,800])
pbaspect([1 1 1])
saveas(gcf,sprintf("./figure/PriorModel2/%s_PostMean.png",datatype))

% variances of error process and random effects (panel c&d)
plot1 = histogram(sigma_samples(burn:iterations));
hold on
meanValue = mean(sigma_samples(burn:iterations));
plot2 = xline(meanValue,'r-', 'LineWidth', 8);
hold off
xlabel(sprintf("Post. Mean: %.2f",meanValue))
set(gca,'fontsize',55)
set(gcf,'position',[10,10,800,800])
pbaspect([1 1 1])
saveas(gcf,sprintf("./figure/PriorModel2/%s_Sigma2.png",datatype))

plot1 = histogram(sigmac_samples(burn:iterations));
hold on
meanValue = mean(sigmac_samples(burn:iterations));
plot2 = xline(meanValue,'r-', 'LineWidth', 8);
hold off
xlabel(sprintf("Post. Mean: %.2f",meanValue))
set(gca,'fontsize',55)
set(gcf,'position',[10,10,800,800])
pbaspect([1 1 1])
saveas(gcf,sprintf("./figure/PriorModel2/%s_Sigmac2.png",datatype))

% posterior samples of phase function (panel d)
first = true;
for i = activeIndeces
    gt = interp1(tG,gamma_samples(i,:,subject_idx),t,'linear');
    gt(end) = 1;
    plot1 = plot(t,gt,'color',[cols(1,:),0.1]);
    if first
        plot_temp = plot(NaN,NaN,'color',cols(1,:),'LineWidth', 3);
        first = false;
    end
    hold on
end
first = true;
for i = burn+1:iterations
    gt = interp1(tG,gamma_samples(i,:,subject_idx),t,'linear');
    gt(end) = 1;
    if first
        post_mean_0 = gt;
        first = false;
    else
        post_mean_0 = post_mean_0 + gt;
    end
end
plot2 = plot(t,post_mean_0/(iterations-burn),'Linewidth',8);
hold off
legend([plot_temp, plot2],{'Post. Samp.','Post. Mean'}, ...
    'Location','best')
set(gca,'fontsize',55)
set(gcf,'position',[10,10,800,800])
pbaspect([1 1 1])
saveas(gcf,sprintf("./figure/PriorModel2/%s_warping.png",datatype))

% observation & rotated posterior samples of fixed effect (panel e)
first = true;
for i = activeIndeces
    qmu_s = U1*a_samples(i,:)';
    gt = interp1(tG,gamma_samples(i,:,subject_idx),t,'linear');
    gt(end) = 1;
    q_warped = qComposeGamma(qmu_s,t,gt);
    plot1 = plot(t,q_warped,'color',[cols(1,:),0.1]);
    hold on
    if first
        plot_temp1 = plot(NaN,NaN,'color',[cols(1,:),1],'LineWidth', 3);
        first = false;
    end
end
plot2 = plot(t,qt{subject_idx},'color','black','linewidth',8);
hold off
ylim([-2 10])
legend([plot_temp1, plot2],{'Rotated fixed effect','Functional ovservation'}, ...
    'Location','northeast')
set(gca,'fontsize',55)
set(gcf,'position',[10,10,800,800])
pbaspect([1 1 1])
saveas(gcf,sprintf("./figure/PriorModel2/%s_warpedMeanandCurve.png",datatype))
close all

