%% calculate Delta_mu comprises column 2-5 of Table 1
dataidx_all = [1,2,3];
main_basis_all = ["Fourier","BSpline"];
random_basis = "BSpline";
basisSize_m = 6;
basisSize_v = 6;
nG = 7;

for dataidx = dataidx_all
    for mx = 1:2
        main_basis = main_basis_all(mx);
        load(sprintf("./data/warpMixData%d_mu.csv",dataidx));
        newVars = struct();
        oldName = sprintf("warpMixData%d_mu",dataidx);
        newName = "mu";
        newVars.(newName) = eval(oldName);
        clear(oldName);
        mu = newVars.mu;
        load(sprintf("./result/warpMixEst_mu%d.csv",dataidx));
        newVars = struct();
        oldName = sprintf("warpMixEst_mu%d",dataidx);
        newName = "mu_est";
        newVars.(newName) = eval(oldName);
        clear(oldName);
        mu_est = newVars.mu_est;
        filename2 = sprintf('./result/Data_WarpMix%d_PriorModel2MCMC_main_%s_random_%s_basisnum_%d_%d_nG_%d.mat', ...
            dataidx,main_basis, random_basis, basisSize_m, basisSize_v, nG);
        filename1 = sprintf('./result/Data_WarpMix%d_PriorModel1MCMC_main_%s_random_%s_basisnum_%d_%d.mat', ...
            dataidx, main_basis, random_basis, basisSize_m, basisSize_v);

        load(filename1)
        clear gamma_samples posterior_samples_warping
        posterior_samples = U1*a_samples(burn:iterations,:)';
        first = true;
        for ii = burn+1:iterations
            qmu_s = U1*a_samples(ii,:)';
            for ind = 1:N
                gamma_samples(:,ind) = t + alpha_samples(ii,ind)*t.*(t-1);
            end
            gt_bar = mean(gamma_samples,2);
            if first
                post_mean = qmu_s;
                post_mean_gam = gt_bar;
                first = false;
            else
                post_mean = post_mean + qmu_s;
                post_mean_gam = post_mean_gam + gt_bar;
            end
            posterior_samples_warping(ii-burn,:) = gt_bar;
        end
        post_mean = post_mean/(iterations-burn);
        post_mean_gam = post_mean_gam/(iterations-burn);
        post_mean_warped = qComposeGamma(post_mean,t,post_mean_gam');
        post_mean_diff2 = (post_mean_warped - mu).^2;
        delta_mu(dataidx,mx) = sum(post_mean_diff2(1:T-1).*(t(2) - t(1)));
        
        load(filename2)
        posterior_samples = U1*a_samples(burn+1:iterations,:)';
        posterior_samples_warping = gamma_samples(burn+1:iterations,:,:);
        posterior_densities = log_jointDensity(burn+1:iterations);
        first = true;
        for ii = burn+1:iterations
            qmu_s = U1*a_samples(ii,:)';
            gam_bar = mean(gamma_samples(ii,:,:),3);
            gt_bar = interp1(tG,gam_bar,t,'linear');
            gt_bar(end) = 1;
            if first
                post_mean = qmu_s;
                post_mean_gam = gt_bar;
                first = false;
            else
                post_mean = post_mean + qmu_s;
                post_mean_gam = post_mean_gam + gt_bar;
            end
        end
        post_mean = post_mean/(iterations-burn);
        post_mean_gam = post_mean_gam/(iterations-burn);
        post_mean_warped = qComposeGamma(post_mean,t,post_mean_gam);
        post_mean_diff2 = (post_mean_warped - mu).^2;
        delta_mu(dataidx,mx+2) = sum(post_mean_diff2(1:T-1).*(t(2) - t(1)));
    end
end
save("./result/warpMixTable1.mat","delta_mu")